//=============================================================================
// VisuStella MZ - Map Event Effects
// VisuMZ_4_MapEventEffects.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_4_MapEventEffects = true;

var VisuMZ = VisuMZ || {};
VisuMZ.MapEventEffects = VisuMZ.MapEventEffects || {};
VisuMZ.MapEventEffects.version = 1.01;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 4] [Version 1.01] [MapEventEffects]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Map_Event_Effects_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * Sometimes for an event cutscene, you want to do more than the available
 * special effects provided by RPG Maker MZ. This plugin adds more functions
 * including hue changes, floating, sidestepping, shaking, scaling, breathing,
 * tinting, and flashing. Use these effects to spice up your map events.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Apply hue effects to your map events. Events can start with specific hues,
 *   within hue ranges.
 * * Hues can shift constantly to give them a chromatic effect.
 * * Map events can float above the ground up and down at different speeds and
 *   at different rates.
 * * Map events can sidestep back and forth to give a left to right movement.
 *   This can be adjusted at different speeds and different rates.
 * * Shake effects can be used to make events appear shivering in place, either
 *   horizontally, vertically, or both.
 * * Events can change their size scaling to appear larger or smaller. This can
 *   be useful when creating giant races or miniature fairies.
 * * Breathing effects can be used to make events appear more bouncy than usual
 *   which is great for certain sprite types like slimes.
 * * Tints can be used to apply an overlay color on top of the existing color
 *   set the sprite has. This can be used for statues or petrification.
 * * Flashing can be made to occur immediately or in cycles. Flashing colors on
 *   an event can indicate various things from self-destruct sequences to
 *   possible evolution.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 4 ------
 *
 * This plugin is a Tier 4 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Effects List
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 * 
 * Breathing
 * 
 * Events with breathing effects will oscillate horizontally and/or vertically
 * in size. This can be applied to horizontal or vertical exclusively when
 * needed in that form.
 * 
 * Though this effect can look overdramatic for regular human sprites,
 * the effect works quite well for certain monster types including slimes,
 * worms, tentacles, etc.
 * 
 * ---
 * 
 * Flash Color
 * 
 * A designated color will flash on the target event. The flash will occur only
 * once and will fade to transparent over a period of time. However, when used
 * with a cycle, a new flash will be generated every cycle amount and the whole
 * color flashing will cycle through again.
 * 
 * This can be used for things like flashing computers, damaged targets,
 * certain monsters getting ready to evolve, you name it.
 * 
 * ---
 * 
 * Floating
 * 
 * Allows the character sprite to float above the ground. The character can
 * hover up and down while at it. If the character moves past a certain height,
 * the character will be deemed "Above Characters" visually to prevent clipping
 * although its movement priority system will still be the same.
 * 
 * The effect can be used for flying creatures like birds, bats, butterflies,
 * fairies, etc. This is best paired with the Sidestep effect to add in some
 * horizontal motion, too.
 * 
 * ---
 *
 * Hue
 * 
 * Adjusts the character sprite's hue property. When used, all of the sprite's
 * color will shift relative to the setting used. Used with a hue change per
 * frame effect and it will create a chromatic rainbow-like effect.
 * 
 * Hue changes to be used to apply slightly different appearances to many
 * events that use the same graphic. They can be off-color from one another and
 * have a bit of distinction.
 *
 * ---
 * 
 * Repeat Animations
 * 
 * Requires VisuMZ_0_CoreEngine! Allows for animations to be played repeatedly
 * on an event. Determine the cycle time for the repeated animation as well as
 * other properties like mirroring it or muting it.
 * 
 * ---
 * 
 * Scale
 * 
 * Changes the size of the character's sprite by a scaling factor. The sprite
 * will appear larger than normal. The horizontal and vertical scaling can be
 * adjusted independently of one another.
 * 
 * This effect can be used to depict different races of various sizes while
 * using repeated graphics. The race of Giants can use a larger scale and the
 * dwarves and halflings can use a smaller scale.
 * 
 * ---
 *
 * Shake
 * 
 * When given shake power, the sprite will move frantically horizontally,
 * and/or vertically. The settings can be made to apply horizontal movement
 * independent of vertical movement, too.
 * 
 * This effect can be used to make a character shiver, freak out, or even
 * cringe at the situation going on.
 *
 * ---
 *
 * Sidestep
 * 
 * Allows the character sprite to move left and/or right instead of being
 * aligned to the tile it's on. The character can constantly shift left and
 * right, too.
 * 
 * This effect can be used to apply to certain objects that aren't normally
 * stationary such as water-based plants. This effect is also useful for
 * hovering objects and entites such as birds, bats, butterflies, etc.
 *
 * ---
 * 
 * Tint Color
 * 
 * Applies a shade of color on top of the sprite's current color scheme. The
 * tint effect can be adjusted to fade towards the next color or the like.
 * 
 * This can be used to make statues by setting a gray-ish tint, making things
 * appear burnt with a reddish tint, covered in soot with a dark-ish tint, and
 * mossy with a dark green-ish tint.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 * 
 * === Breathing-Related Notetags ===
 * 
 * ---
 * 
 * <Breathing Rate: x%>
 *
 * <Breathing Rate X: x%>
 * <Breathing Rate Y: y%>
 * 
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Changes the breathing rate of the sprite to the percentile amount.
 * - For <Breathing Rate: x%> variant: replace 'x' with a number representing
 *   the general breathing percentage to be used.
 * - For <Breathing Rate X: x%> variant: replace 'x' with a number representing
 *   the horizontal breathing percentage to be used.
 * - For <Breathing Rate Y: y%> variant: replace 'y' with a number representing
 *   the vertical breathing percentage to be used.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * <Breathing Speed: x>
 *
 * <Breathing Speed X: x>
 * <Breathing Speed Y: y>
 * 
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Changes the breathing speed of the sprite.
 * - For <Breathing Speed: x%> variant: replace 'x' with a number representing
 *   the general breathing speed rate to be used.
 *   - For best results, use numbers between 0 and 1.
 * - For <Breathing Speed X: x%> variant: replace 'x' with a number
 *   representing the horizontal breathing speed rate to be used.
 *   - For best results, use numbers between 0 and 1.
 * - For <Breathing Speed Y: y%> variant: replace 'y' with a number
 *   representing the vertical breathing speed rate to be used.
 *   - For best results, use numbers between 0 and 1.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Breathing Random Offset>
 * 
 * <Breathing Random Offset X>
 * <Breathing Random Offset Y>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Makes the event's breathing rate effect different from other events by
 *   having different starting points.
 *   - This effect does NOT work with <Breathing Static Offset: x> variants.
 * - For <Breathing Random Offset> variant, this will affect both breathing
 *   rates for horizontal and vertical directions.
 * - For <Breathing Random Offset X> variant, this will affect only breathing
 *   rates for the horizontal direction.
 * - For <Breathing Random Offset Y> variant, this will affect only breathing
 *   rates for the vertical direction.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Breathing Static Offset: x>
 * 
 * <Breathing Static Offset X: x>
 * <Breathing Static Offset Y: y>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Makes the event's breathing rate starting count begin at 'x' and will
 *   share similar starting float height offsets with other events that use the
 *   same offset number.
 *   - This effect does NOT work with <Breathing Random Offset> variants.
 * - For <Breathing Static Offset: x> variant, replace 'x' with a number that
 *   adjusts the starting point for both horizontal and vertical breathing.
 * - For <Breathing Static Offset X: x> variant, replace 'x' with a number that
 *   adjusts the starting point for only horizontal breathing.
 * - For <Breathing Static Offset Y: y> variant, replace 'y' with a number that
 *   adjusts the starting point for only vertical breathing.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * === Flash-Related Notetags ===
 * 
 * ---
 *
 * <Flash Color: r, g, b, a>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Gives the event an effect that will periodically flash a custom color.
 * - Replace 'r' with a number representing the red color value (0 to 255).
 * - Replace 'g' with a number representing the green color value (0 to 255).
 * - Replace 'b' with a number representing the blue color value (0 to 255).
 * - Replace 'a' with a number representing the alpha value (0 to 255).
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * <Flash Duration: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the duration of the flash effect to 'x' frames.
 * - Replace 'x' with a number representing how long the flash lasts in frames.
 *   - 60 frames per second.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 * - If this notetag is not used, use the default flash duration found within
 *   the Plugin Parameters.
 * 
 * ---
 * 
 * <Flash Cycle: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the cycle time of the flash effect to 'x' frames.
 * - Replace 'x' with a number representing how long the flash cycle begins
 *   anew again.
 *   - 60 frames per second.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 * - If this notetag is not used, use the default flash cycle found within
 *   the Plugin Parameters.
 * 
 * ---
 * 
 * === Floating-Related Notetags ===
 * 
 * ---
 *
 * <Float Height: x>
 * 
 * <Float Height: x to y>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's float height to 'x' or hover between 'x' and 'y'.
 * - With the <Float Height: x> variant: replace 'x' with a number representing
 *   the pixels off the ground.
 * - With the <Float Height: x to y> variant, replace 'x' and 'y' with numbers
 *   representing what pixel heights to shift between.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Float Speed: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's float speed to 'x' for the hovering float effect.
 * - Replace 'x' with a number representing the speed at which the event floats
 *   between heights with.
 *   - For best results, use a number between 0 and 1.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Float Random Offset>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Makes the event's floating height effect different from other events by
 *   having different starting points.
 *   - This effect does NOT work with <Float Static Offset: x>.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Float Static Offset: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Makes the event's floating height starting count begin at 'x' and will
 *   share similar starting float height offsets with other events that use the
 *   same offset number.
 *   - This effect does NOT work with <Float Random Offset>.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * === Hue-Related Notetags ===
 * 
 * ---
 *
 * <Hue: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's hue color to 'x'.
 * - Replace 'x' with a number representing the hue shift.
 *   - For best results, use a number between 0 and 360.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Random Hue>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's hue color to a random amount between 0 and 360.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Random Hue: x to y>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's hue color to a random amount between 'x' and 'y'.
 * - Replace 'x' and 'y' with numbers representing the hue shifts.
 *   - For best results, use numbers between 0 and 360.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Hue Per Frame: +x>
 * <Hue Per Frame: -x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - The event will constantly shift hue values by 'x' each frame.
 * - Replace 'x' with a number representing the hue shift.
 *   - For best results, use a number between 0 and 360.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * === Repeat Animation-Related Notetags ===
 * 
 * ---
 *
 * <Repeat Animation: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Plays animation 'x' on event over and over.
 * - Replace 'x' with a number representing the ID of the animation to be
 *   played on this event repeatedly.
 *   - Keep in mind that if an event changes pages to one that does not have an
 *     animation or if the event is erased, the animation will still have to
 *     finish up playing.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Repeat Animation Cycle: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Determines the animation cycle used for repeated animations. Animations
 *   will be repeated every 'x' frames.
 * - Replace 'x' with a number representing the frame count between each
 *   animation playthrough. 60 frames = 1 second.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Repeat Animation Mirror: On>
 * <Repeat Animation Mirror: Off>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Determines if the repeating animation is mirrored or not.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Repeat Animation Mute: On>
 * <Repeat Animation Mute: Off>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Determines if the repeating animation is muted or not.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * === Scale-Related Notetags ===
 * 
 * ---
 * 
 * <Scale: x%>
 * 
 * <Scale X: x%>
 * <Scale Y: y%>
 * 
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Changes the scale of the sprite to the designated size.
 * - For <Scale: x%> variant: replace 'x' with a number representing the
 *   scaling overall percentage to be used.
 * - For <Scale X: x%> variant, replace 'x' with a number representing the x
 *   factor for the horizontal scaling percentage to be used.
 * - For <Scale Y: y%> variant, replace 'y' with a number representing the y
 *   factor for the vertical scaling percentage to be used.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * === Shake-Related Notetags ===
 * 
 * ---
 *
 * <Shake Power: x>
 * 
 * <Shake Power X: x>
 * <Shake Power Y: y>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's shaking to 'x' and/or 'y' power.
 * - For <Shake Power: x> variant: replace 'x' with a number representing the
 *   shake power used for both horizontal and vertical shaking.
 * - For <Shake Power X: x> variant: replace 'x' with a number representing the
 *   shake power used for only horizontal shaking.
 * - For <Shake Power Y: y> variant: replace 'y' with a number representing the
 *   shake power used for only vertical shaking.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * === Sidestepping-Related Notetags ===
 * 
 * ---
 *
 * <Sidestep: x>
 * 
 * <Sidestep: x to y>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's sidestep distance to 'x' or hover between 'x' and 'y'.
 * - With the <Sidestep: x> variant: replace 'x' with a number representing
 *   the pixels to the side.
 *   - Negative numbers go left. Positive numbers go right.
 * - With the <Sidestep: x to y> variant, replace 'x' and 'y' with numbers
 *   representing what pixel heights to shift between.
 *   - Negative numbers go left. Positive numbers go right.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Sidestep Speed: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Sets the event's shifting speed to 'x' for the sidestepping effect.
 * - Replace 'x' with a number representing the speed at which the event will
 *   sidestep between.
 *   - For best results, use a number between 0 and 1.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Sidestep Random Offset>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Makes the event's sidestepping effect different from other events by
 *   having different starting points.
 *   - This effect does NOT work with <Sidestep Static Offset: x>.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * <Sidestep Static Offset: x>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Makes the event's sidestepping distance starting count begin at 'x' and
 *   will share similar starting sidestep static offsets with other events that
 *   use the same offset number.
 *   - This effect does NOT work with <Sidestep Random Offset>.
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 * 
 * === Tint-Related Notetags ===
 * 
 * ---
 *
 * <Tint Color: r, g, b, k>
 *
 * - Used for: Event Notetags and Event Page Comment Tags
 * - Tints the event with a custom tone.
 * - Replace 'r' with a number representing the red tone value (-255 to 255).
 * - Replace 'g' with a number representing the green tone value (-255 to 255).
 * - Replace 'b' with a number representing the blue tone value (-255 to 255).
 * - Replace 'k' with a number representing the grey tone value (0 to 255).
 * - If this is placed in a notetag, the effect will be present across
 *   all event pages used.
 * - If this is placed inside a page's comment, the effect will only occur
 *   if that event page is currently active.
 *
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Breathing-Related Plugin Commands ===
 * 
 * ---
 *
 * Breathing: Change for Event
 * - Changes target event's character's breathing.
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 *
 *   Breathing Rate X:
 *   - What is the breathing rate X in pixels?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Rate Y:
 *   - What is the breathing rate Y in pixels?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Speed X:
 *   - What is the speed X used for breathing?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Speed Y:
 *   - What is the speed Y used for breathing?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Breathing: Change for Follower
 * - Changes target follower's character's breathing.
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 *
 *   Breathing Rate X:
 *   - What is the breathing rate X in pixels?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Rate Y:
 *   - What is the breathing rate Y in pixels?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Speed X:
 *   - What is the speed X used for breathing?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Speed Y:
 *   - What is the speed Y used for breathing?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Breathing: Change for Player
 * - Changes player character's breathing.
 *
 *   Breathing Rate X:
 *   - What is the breathing rate X in pixels?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Rate Y:
 *   - What is the breathing rate Y in pixels?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Speed X:
 *   - What is the speed X used for breathing?
 *   - For best results, use a number between 0 and 1.
 *
 *   Breathing Speed Y:
 *   - What is the speed Y used for breathing?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 * 
 * === Flash-Related Plugin Commands ===
 * 
 * ---
 *
 * Flash: Change for Event
 * - Changes target event's character's flash color.
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 * 
 *   Flash Color:
 * 
 *     Red:
 *     Green:
 *     Blue:
 *     Alpha:
 *     - What is the flash value?
 *     - Use a number between 0 and 5.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Flash: Change for Follower
 * - Changes target follower's character's flash color.
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 * 
 *   Flash Color:
 * 
 *     Red:
 *     Green:
 *     Blue:
 *     Alpha:
 *     - What is the flash value?
 *     - Use a number between 0 and 5.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Flash: Change for Player
 * - Changes player character's flash color.
 * 
 *   Flash Color:
 * 
 *     Red:
 *     Green:
 *     Blue:
 *     Alpha:
 *     - What is the flash value?
 *     - Use a number between 0 and 5.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 * 
 * === Float-Related Plugin Commands ===
 * 
 * ---
 *
 * Float: Change for Event
 * - Changes target event's character's float height.
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 * 
 *   Minimum Float Height:
 *   - What is the minimum float height in pixels?
 * 
 *   Maximum Float Height:
 *   - What is the maximum float height in pixels?
 * 
 *   Float Speed:
 *   - What is the speed used for floating?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Float: Change for Follower
 * - Changes target follower's character's float height.
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 * 
 *   Minimum Float Height:
 *   - What is the minimum float height in pixels?
 * 
 *   Maximum Float Height:
 *   - What is the maximum float height in pixels?
 * 
 *   Float Speed:
 *   - What is the speed used for floating?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Float: Change for Player
 * - Changes player character's float height.
 * 
 *   Minimum Float Height:
 *   - What is the minimum float height in pixels?
 * 
 *   Maximum Float Height:
 *   - What is the maximum float height in pixels?
 * 
 *   Float Speed:
 *   - What is the speed used for floating?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 * 
 * === Hue-Related Plugin Commands ===
 * 
 * ---
 *
 * Hue: Change for Event
 * - Changes target event's character's hue.
 * 
 *   Hue:
 *   - Changes the sprite to use this hue.
 *   - Use a number between 0 and 360.
 *
 * ---
 *
 * Hue: Change for Follower
 * - Changes target follower's character's hue.
 * 
 *   Hue:
 *   - Changes the sprite to use this hue.
 *   - Use a number between 0 and 360.
 *
 * ---
 *
 * Hue: Change for Player
 * - Changes player character's hue.
 * 
 *   Hue:
 *   - Changes the sprite to use this hue.
 *   - Use a number between 0 and 360.
 *
 * ---
 * 
 * === Repeat Animation-Related Plugin Commands ===
 * 
 * ---
 * 
 * Repeat Animation: Change for Event
 * - Changes target event's character's Repeat Animation.
 * - Requires VisuMZ_0_CoreEngine!
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 * 
 *   Animation ID:
 *   - Repeat which animation?
 *   - Use 0 for no animation.
 * 
 *   Repeat Cycle:
 *   - How many frames to wait between each animation?
 *   - 60 frames = 1 second.
 * 
 *   Mirror Animation:
 *   - Mirror the repeat animation?
 * 
 *   Mute Animation:
 *   - Mute the repeat animation?
 * 
 * ---
 * 
 * Repeat Animation: Change for Follower
 * - Changes target follower's character's Repeat Animation.
 * - Requires VisuMZ_0_CoreEngine!
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 * 
 *   Animation ID:
 *   - Repeat which animation?
 *   - Use 0 for no animation.
 * 
 *   Repeat Cycle:
 *   - How many frames to wait between each animation?
 *   - 60 frames = 1 second.
 * 
 *   Mirror Animation:
 *   - Mirror the repeat animation?
 * 
 *   Mute Animation:
 *   - Mute the repeat animation?
 * 
 * ---
 * 
 * Repeat Animation: Change for Player
 * - Changes target player's character's Repeat Animation.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Repeat which animation?
 *   - Use 0 for no animation.
 * 
 *   Repeat Cycle:
 *   - How many frames to wait between each animation?
 *   - 60 frames = 1 second.
 * 
 *   Mirror Animation:
 *   - Mirror the repeat animation?
 * 
 *   Mute Animation:
 *   - Mute the repeat animation?
 * 
 * ---
 * 
 * === Scale-Related Plugin Commands ===
 * 
 * ---
 *
 * Scale: Change for Event
 * - Changes target event's character's scale factor.
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 * 
 *   Scale X:
 *   Scale Y:
 *   - What is the target scale X/Y?
 *   - 0.00 - 0%, 0.50 - 50%, 1.00 - 100%, 1.50 - 150%
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Scale: Change for Follower
 * - Changes target follower's character's scale factor.
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 * 
 *   Scale X:
 *   Scale Y:
 *   - What is the target scale X/Y?
 *   - 0.00 - 0%, 0.50 - 50%, 1.00 - 100%, 1.50 - 150%
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Scale: Change for Player
 * - Changes player character's scale factor.
 * 
 *   Scale X:
 *   Scale Y:
 *   - What is the target scale X/Y?
 *   - 0.00 - 0%, 0.50 - 50%, 1.00 - 100%, 1.50 - 150%
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 * 
 * === Shake-Related Plugin Commands ===
 * 
 * ---
 *
 * Shake: Change for Event
 * - Changes target event's character's shaking.
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 * 
 *   Shake Power X:
 *   Shake Power Y:
 *   - Input the horizontal/vertical shaking power.
 *
 * ---
 *
 * Shake: Change for Follower
 * - Changes target follower's character's shaking.
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 * 
 *   Shake Power X:
 *   Shake Power Y:
 *   - Input the horizontal/vertical shaking power.
 *
 * ---
 *
 * Shake: Change for Player
 * - Changes player character's shaking.
 * 
 *   Shake Power X:
 *   Shake Power Y:
 *   - Input the horizontal/vertical shaking power.
 *
 * ---
 * 
 * === Sidestep-Related Plugin Commands ===
 * 
 * ---
 *
 * Sidestep: Change for Event
 * - Changes target event's character's sidestep distance.
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 * 
 *   Minimum Sidestep:
 *   - What is the minimum Sidestep distance in pixels?
 *   - Negative: Left; Positive: Right.
 * 
 *   Maximum Sidestep:
 *   - What is the maximum Sidestep distance in pixels?
 *   - Negative: Left; Positive: Right.
 * 
 *   Sidestep Speed:
 *   - What is the speed used for Sidesteping?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Sidestep: Change for Follower
 * - Changes target follower's character's sidestep distance.
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 * 
 *   Minimum Sidestep:
 *   - What is the minimum Sidestep distance in pixels?
 *   - Negative: Left; Positive: Right.
 * 
 *   Maximum Sidestep:
 *   - What is the maximum Sidestep distance in pixels?
 *   - Negative: Left; Positive: Right.
 * 
 *   Sidestep Speed:
 *   - What is the speed used for Sidesteping?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Sidestep: Change for Player
 * - Changes player character's sidestep distance.
 * 
 *   Minimum Sidestep:
 *   - What is the minimum Sidestep distance in pixels?
 *   - Negative: Left; Positive: Right.
 * 
 *   Maximum Sidestep:
 *   - What is the maximum Sidestep distance in pixels?
 *   - Negative: Left; Positive: Right.
 * 
 *   Sidestep Speed:
 *   - What is the speed used for Sidesteping?
 *   - For best results, use a number between 0 and 1.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 * 
 * === Tint-Related Plugin Commands ===
 * 
 * ---
 *
 * Tint: Change for Event
 * - Changes target event's character's tint color.
 *
 *   Event ID:
 *   - Insert the ID of the target event.
 *   - Use 0 for the current event.
 * 
 *   Color:
 * 
 *     Red:
 *     Green:
 *     Blue:
 *     Gray:
 *     - What is the tint color value?
 *     - For red, green, blue, use a number between -255 and 255.
 *     - For gray, use a number between 0 and 255.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Tint: Change for Follower
 * - Changes target follower's character's tint color.
 *
 *   Follower ID:
 *   - Select which follower ID to change for.
 *   - Follower ID's start at 1.
 * 
 *   Color:
 * 
 *     Red:
 *     Green:
 *     Blue:
 *     Gray:
 *     - What is the tint color value?
 *     - For red, green, blue, use a number between -255 and 255.
 *     - For gray, use a number between 0 and 255.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * Tint: Change for Player
 * - Changes player character's tint color.
 * 
 *   Color:
 * 
 *     Red:
 *     Green:
 *     Blue:
 *     Gray:
 *     - What is the tint color value?
 *     - For red, green, blue, use a number between -255 and 255.
 *     - For gray, use a number between 0 and 255.
 *
 *   Duration:
 *   - The duration in frames for which this change takes place.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: General Settings
 * ============================================================================
 *
 * These are the general settings used for this plugin. These are mostly
 * settings used to define the default values made for the plugin and there is
 * one visual effect that is applied globally.
 *
 * ---
 *
 * Defaults
 * 
 *   Breathing Speed X:
 *   Breathing Speed Y:
 *   - What is the default horizontal/vertical breating speed?
 *   - For best results, use a number between 0 and 1.
 * 
 *   Flash Duration:
 *   - What is the default frame duration for flashes?
 *   - 60 frames = 1 second.
 * 
 *   Flash Cycle:
 *   - What is the default frame cycle time for flashes?
 *   - 60 frames = 1 second.
 * 
 *   Float Speed:
 *   - What is the default floating speed?
 *   - For best results, use a number between 0 and 1.
 * 
 *   Repeat Animation Cycle:
 *   - How many frames to wait between each animation?
 *   - 60 frames = 1 second.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *     Mirror Animation:
 *     - Mirror the repeat animation?
 *     - Requires VisuMZ_0_CoreEngine.
 * 
 *     Mute Animation:
 *     - Mute the repeat animation?
 *     - Requires VisuMZ_0_CoreEngine.
 * 
 *   Sidestep Speed:
 *   - What is the default sidestep speed?
 *   - For best results, use a number between 0 and 1.
 *
 * ---
 *
 * Settings
 * 
 *   Float Change Z:
 *   - Past what height does the event change Z layers?
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Arisu
 * * Olivia
 * * Irina
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.01: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug with the <Sidestep: x to y> notetag not working properly.
 *    Fix made by Arisu.
 * * Documentation Update!
 * ** Added new section in "Effects List" for Repeat Animations.
 * *** Requires VisuMZ_0_CoreEngine! Allows for animations to be played
 *     repeatedly on an event. Determine the cycle time for the repeated
 *     animation as well as other properties like mirroring it or muting it.
 * ** Help file updated for new features.
 * * New Features!
 * ** New Notetags added by Irina and sponsored by Archeia:
 * *** <Repeat Animation: x>
 * *** <Repeat Animation Cycle: x>
 * *** <Repeat Animation Mirror: on/off>
 * *** <Repeat Animation Mute: on/off>
 * **** Refer to help file for more information.
 * ** New Plugin Commands added by Irina and sponsored by Archeia:
 * *** Repeat Animation: Change for Event
 * *** Repeat Animation: Change for Follower
 * *** Repeat Animation: Change for Player
 * ** New Plugin Parameters added by Irina and sponsored by Archeia:
 * *** Default > Repeat Animation Cycle
 * *** Default > Mirror Animation
 * *** Default > Mute Animation
 * 
 * Version 1.00 Official Release Date: July 24, 2023
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Begin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Breathing_ChangeFor_Event
 * @text Breathing: Change for Event
 * @desc Changes target event's character's breathing.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 *
 * @arg BreathingRateX:eval
 * @text Breathing Rate X
 * @desc What is the breathing rate X in pixels?
 * For best results, use a number between 0 and 1.
 * @default 0.00
 *
 * @arg BreathingRateY:eval
 * @text Breathing Rate Y
 * @desc What is the breathing rate Y in pixels?
 * For best results, use a number between 0 and 1.
 * @default 0.00
 *
 * @arg BreathingSpeedX:eval
 * @text Breathing Speed X
 * @desc What is the speed X used for breathing?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 *
 * @arg BreathingSpeedY:eval
 * @text Breathing Speed Y
 * @desc What is the speed Y used for breathing?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Breathing_ChangeFor_Follower
 * @text Breathing: Change for Follower
 * @desc Changes target follower's character's breathing.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 *
 * @arg BreathingRateX:eval
 * @text Breathing Rate X
 * @desc What is the breathing rate X in pixels?
 * For best results, use a number between 0 and 1.
 * @default 0.00
 *
 * @arg BreathingRateY:eval
 * @text Breathing Rate Y
 * @desc What is the breathing rate Y in pixels?
 * For best results, use a number between 0 and 1.
 * @default 0.00
 *
 * @arg BreathingSpeedX:eval
 * @text Breathing Speed X
 * @desc What is the speed X used for breathing?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 *
 * @arg BreathingSpeedY:eval
 * @text Breathing Speed Y
 * @desc What is the speed Y used for breathing?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Breathing_ChangeFor_Player
 * @text Breathing: Change for Player
 * @desc Changes player character's breathing.
 *
 * @arg BreathingRateX:eval
 * @text Breathing Rate X
 * @desc What is the breathing rate X in pixels?
 * For best results, use a number between 0 and 1.
 * @default 0.00
 *
 * @arg BreathingRateY:eval
 * @text Breathing Rate Y
 * @desc What is the breathing rate Y in pixels?
 * For best results, use a number between 0 and 1.
 * @default 0.00
 *
 * @arg BreathingSpeedX:eval
 * @text Breathing Speed X
 * @desc What is the speed X used for breathing?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 *
 * @arg BreathingSpeedY:eval
 * @text Breathing Speed Y
 * @desc What is the speed Y used for breathing?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Flash
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Flash_ChangeFor_Event
 * @text Flash: Change for Event
 * @desc Changes target event's character's flash color.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 * 
 * @arg Color
 * @text Flash Color
 *
 * @arg ColorRed:eval
 * @text Red
 * @parent Color
 * @desc What is the red flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorGreen:eval
 * @text Green
 * @parent Color
 * @desc What is the green flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorBlue:eval
 * @text Blue
 * @parent Color
 * @desc What is the blue flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorAlpha:eval
 * @text Alpha
 * @parent Color
 * @desc What is the gray flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @arg Cycle:eval
 * @text Cycle
 * @desc The cycle in frames for which this resets and starts over.
 * Use 0 to not cycle.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Flash_ChangeFor_Follower
 * @text Flash: Change for Follower
 * @desc Changes target follower's character's flash color.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 * 
 * @arg Color
 * @text Flash Color
 *
 * @arg ColorRed:eval
 * @text Red
 * @parent Color
 * @desc What is the red flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorGreen:eval
 * @text Green
 * @parent Color
 * @desc What is the green flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorBlue:eval
 * @text Blue
 * @parent Color
 * @desc What is the blue flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorAlpha:eval
 * @text Alpha
 * @parent Color
 * @desc What is the gray flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @arg Cycle:eval
 * @text Cycle
 * @desc The cycle in frames for which this resets and starts over.
 * Use 0 to not cycle.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Flash_ChangeFor_Player
 * @text Flash: Change for Player
 * @desc Changes player character's flash color.
 * 
 * @arg Color
 * @text Flash Color
 *
 * @arg ColorRed:eval
 * @text Red
 * @parent Color
 * @desc What is the red flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorGreen:eval
 * @text Green
 * @parent Color
 * @desc What is the green flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorBlue:eval
 * @text Blue
 * @parent Color
 * @desc What is the blue flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg ColorAlpha:eval
 * @text Alpha
 * @parent Color
 * @desc What is the gray flash value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @arg Cycle:eval
 * @text Cycle
 * @desc The cycle in frames for which this resets and starts over.
 * Use 0 to not cycle.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Float
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Float_ChangeFor_Event
 * @text Float: Change for Event
 * @desc Changes target event's character's float height.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 *
 * @arg FloatMin:eval
 * @text Minimum Float Height
 * @desc What is the minimum float height in pixels?
 * @default 0
 *
 * @arg FloatMax:eval
 * @text Maximum Float Height
 * @desc What is the maximum float height in pixels?
 * @default 0
 *
 * @arg FloatSpeed:eval
 * @text Float Speed
 * @desc What is the speed used for floating?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Float_ChangeFor_Follower
 * @text Float: Change for Follower
 * @desc Changes target follower's character's float height.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 *
 * @arg FloatMin:eval
 * @text Minimum Float Height
 * @desc What is the minimum float height in pixels?
 * @default 0
 *
 * @arg FloatMax:eval
 * @text Maximum Float Height
 * @desc What is the maximum float height in pixels?
 * @default 0
 *
 * @arg FloatSpeed:eval
 * @text Float Speed
 * @desc What is the speed used for floating?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Float_ChangeFor_Player
 * @text Float: Change for Player
 * @desc Changes player character's float height.
 *
 * @arg FloatMin:eval
 * @text Minimum Float Height
 * @desc What is the minimum float height in pixels?
 * @default 0
 *
 * @arg FloatMax:eval
 * @text Maximum Float Height
 * @desc What is the maximum float height in pixels?
 * @default 0
 *
 * @arg FloatSpeed:eval
 * @text Float Speed
 * @desc What is the speed used for floating?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Hue
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Hue_ChangeFor_Event
 * @text Hue: Change for Event
 * @desc Changes target event's character's hue.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 *
 * @arg Hue:eval
 * @text Hue
 * @desc Changes the sprite to use this hue.
 * Use a number between 0 and 360.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Hue_ChangeFor_Follower
 * @text Hue: Change for Follower
 * @desc Changes target follower's character's hue.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 *
 * @arg Hue:eval
 * @text Hue
 * @desc Changes the sprite to use this hue.
 * Use a number between 0 and 360.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Hue_ChangeFor_Player
 * @text Hue: Change for Player
 * @desc Changes player character's hue.
 *
 * @arg Hue:eval
 * @text Hue
 * @desc Changes the sprite to use this hue.
 * Use a number between 0 and 360.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_RepeatAni
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command RepeatAni_ChangeFor_Event
 * @text Repeat Animation: Change for Event
 * @desc Changes target event's character's Repeat Animation.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Repeat which animation?
 * Use 0 for no animation.
 * @default 0
 *
 * @arg RepeatCycle:eval
 * @text Repeat Cycle
 * @desc How many frames to wait between each animation?
 * 60 frames = 1 second.
 * @default 60
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the repeat animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the repeat animation?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command RepeatAni_ChangeFor_Follower
 * @text Repeat Animation: Change for Follower
 * @desc Changes target follower's character's Repeat Animation.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Repeat which animation?
 * Use 0 for no animation.
 * @default 0
 *
 * @arg RepeatCycle:eval
 * @text Repeat Cycle
 * @desc How many frames to wait between each animation?
 * 60 frames = 1 second.
 * @default 60
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the repeat animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the repeat animation?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command RepeatAni_ChangeFor_Player
 * @text Repeat Animation: Change for Player
 * @desc Changes player character's Repeat Animation.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Repeat which animation?
 * Use 0 for no animation.
 * @default 0
 *
 * @arg RepeatCycle:eval
 * @text Repeat Cycle
 * @desc How many frames to wait between each animation?
 * 60 frames = 1 second.
 * @default 60
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the repeat animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the repeat animation?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Scale
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Scale_ChangeFor_Event
 * @text Scale: Change for Event
 * @desc Changes target event's character's scale factor.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 *
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What is the target scale X?
 * 0.00 - 0%, 0.50 - 50%, 1.00 - 100%, 1.50 - 150%
 * @default 1.00
 *
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What is the target scale Y?
 * 0.00 - 0%, 0.50 - 50%, 1.00 - 100%, 1.50 - 150%
 * @default 1.00
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Scale_ChangeFor_Follower
 * @text Scale: Change for Follower
 * @desc Changes target follower's character's scale factor.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 *
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What is the target scale X?
 * @default 0
 *
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What is the target scale Y?
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Scale_ChangeFor_Player
 * @text Scale: Change for Player
 * @desc Changes player character's scale factor.
 *
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What is the target scale X?
 * @default 0
 *
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What is the target scale Y?
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Shake
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Shake_ChangeFor_Event
 * @text Shake: Change for Event
 * @desc Changes target event's character's shaking.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 *
 * @arg ShakeX:eval
 * @text Shake Power X
 * @desc Input the horizontal shaking power.
 * @default 0
 *
 * @arg ShakeY:eval
 * @text Shake Power Y
 * @desc Input the vertical shaking power.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Shake_ChangeFor_Follower
 * @text Shake: Change for Follower
 * @desc Changes target follower's character's shaking.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 *
 * @arg ShakeX:eval
 * @text Shake Power X
 * @desc Input the horizontal shaking power.
 * @default 0
 *
 * @arg ShakeY:eval
 * @text Shake Power Y
 * @desc Input the vertical shaking power.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Shake_ChangeFor_Player
 * @text Shake: Change for Player
 * @desc Changes player character's hue.
 *
 * @arg ShakeX:eval
 * @text Shake Power X
 * @desc Input the horizontal shaking power.
 * @default 0
 *
 * @arg ShakeY:eval
 * @text Shake Power Y
 * @desc Input the vertical shaking power.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Sidestep
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Sidestep_ChangeFor_Event
 * @text Sidestep: Change for Event
 * @desc Changes target event's character's Sidestep distance.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 *
 * @arg SidestepMin:eval
 * @text Minimum Sidestep
 * @desc What is the minimum Sidestep distance in pixels?
 * Negative: Left; Positive: Right.
 * @default +0
 *
 * @arg SidestepMax:eval
 * @text Maximum Sidestep
 * @desc What is the maximum Sidestep distance in pixels?
 * Negative: Left; Positive: Right.
 * @default +0
 *
 * @arg SidestepSpeed:eval
 * @text Sidestep Speed
 * @desc What is the speed used for Sidesteping?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Sidestep_ChangeFor_Follower
 * @text Sidestep: Change for Follower
 * @desc Changes target follower's character's Sidestep distance.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 *
 * @arg SidestepMin:eval
 * @text Minimum Sidestep
 * @desc What is the minimum Sidestep distance in pixels?
 * Negative: Left; Positive: Right.
 * @default +0
 *
 * @arg SidestepMax:eval
 * @text Maximum Sidestep
 * @desc What is the maximum Sidestep distance in pixels?
 * Negative: Left; Positive: Right.
 * @default +0
 *
 * @arg SidestepSpeed:eval
 * @text Sidestep Speed
 * @desc What is the speed used for Sidesteping?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Sidestep_ChangeFor_Player
 * @text Sidestep: Change for Player
 * @desc Changes player character's Sidestep distance.
 *
 * @arg SidestepMin:eval
 * @text Minimum Sidestep
 * @desc What is the minimum Sidestep distance in pixels?
 * Negative: Left; Positive: Right.
 * @default +0
 *
 * @arg SidestepMax:eval
 * @text Maximum Sidestep
 * @desc What is the maximum Sidestep distance in pixels?
 * Negative: Left; Positive: Right.
 * @default +0
 *
 * @arg SidestepSpeed:eval
 * @text Sidestep Speed
 * @desc What is the speed used for Sidesteping?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Tint
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Tint_ChangeFor_Event
 * @text Tint: Change for Event
 * @desc Changes target event's character's tint color.
 *
 * @arg EventID:eval
 * @text Event ID
 * @desc Insert the ID of the target event.
 * Use 0 for the current event.
 * @default 0
 * 
 * @arg Color
 * @text Tint Color
 *
 * @arg ColorRed:eval
 * @text Red
 * @parent Color
 * @desc What is the red tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorGreen:eval
 * @text Green
 * @parent Color
 * @desc What is the green tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorBlue:eval
 * @text Blue
 * @parent Color
 * @desc What is the blue tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorGray:eval
 * @text Gray
 * @parent Color
 * @desc What is the gray tint value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Tint_ChangeFor_Follower
 * @text Tint: Change for Follower
 * @desc Changes target follower's character's tint color.
 *
 * @arg FollowerID:eval
 * @text Follower ID
 * @desc Select which follower ID to change for.
 * Follower ID's start at 1.
 * @default 1
 * 
 * @arg Color
 * @text Tint Color
 *
 * @arg ColorRed:eval
 * @text Red
 * @parent Color
 * @desc What is the red tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorGreen:eval
 * @text Green
 * @parent Color
 * @desc What is the green tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorBlue:eval
 * @text Blue
 * @parent Color
 * @desc What is the blue tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorGray:eval
 * @text Gray
 * @parent Color
 * @desc What is the gray tint value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Tint_ChangeFor_Player
 * @text Tint: Change for Player
 * @desc Changes player character's tint color.
 * 
 * @arg Color
 * @text Tint Color
 *
 * @arg ColorRed:eval
 * @text Red
 * @parent Color
 * @desc What is the red tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorGreen:eval
 * @text Green
 * @parent Color
 * @desc What is the green tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorBlue:eval
 * @text Blue
 * @parent Color
 * @desc What is the blue tint value?
 * Use a number between -255 and 255.
 * @default 0
 *
 * @arg ColorGray:eval
 * @text Gray
 * @parent Color
 * @desc What is the gray tint value?
 * Use a number between 0 and 255.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc The duration in frames for which this change takes place.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param MapEventEffects
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Defaults
 * 
 * @param breathingSpeedX:num
 * @text Breathing Speed X
 * @parent Defaults
 * @desc What is the default horizontal breating speed?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 * 
 * @param breathingSpeedY:num
 * @text Breathing Speed Y
 * @parent Defaults
 * @desc What is the default vertical breating speed?
 * For best results, use a number between 0 and 1.
 * @default 0.08
 * 
 * @param flashDuration:num
 * @text Flash Duration
 * @parent Defaults
 * @desc What is the default frame duration for flashes?
 * 60 frames = 1 second.
 * @default 20
 * 
 * @param flashCycle:num
 * @text Flash Cycle
 * @parent Defaults
 * @desc What is the default frame cycle time for flashes?
 * 60 frames = 1 second.
 * @default 60
 * 
 * @param floatSpeed:num
 * @text Float Speed
 * @parent Defaults
 * @desc What is the default floating speed?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 * 
 * @param repeatAniCycle:num
 * @text Repeat Animation Cycle
 * @parent Defaults
 * @desc How many frames to wait between each animation?
 * Requires VisuMZ_0_CoreEngine. 60 frames = 1 second.
 * @default 60
 *
 * @param repeatAniMirror:eval
 * @text Mirror Animation
 * @parent repeatAniCycle:num
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the repeat animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default false
 *
 * @param repeatAniMute:eval
 * @text Mute Animation
 * @parent repeatAniCycle:num
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the repeat animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default true
 * 
 * @param sidestepSpeed:num
 * @text Sidestep Speed
 * @parent Defaults
 * @desc What is the default sidestep speed?
 * For best results, use a number between 0 and 1.
 * @default 0.04
 * 
 * @param Settings
 * 
 * @param floatHeightChangeZ:num
 * @text Float Change Z
 * @parent Settings
 * @desc Past what height does the event change Z layers?
 * @default 42
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
//=============================================================================

const _0x2a107e=_0xfdf3;(function(_0x135d80,_0x55001e){const _0x56d387=_0xfdf3,_0x14d5b7=_0x135d80();while(!![]){try{const _0x1bea0=-parseInt(_0x56d387(0x218))/0x1*(-parseInt(_0x56d387(0x1c0))/0x2)+parseInt(_0x56d387(0x211))/0x3+parseInt(_0x56d387(0x1d3))/0x4*(parseInt(_0x56d387(0x1d0))/0x5)+parseInt(_0x56d387(0x19b))/0x6*(parseInt(_0x56d387(0x1a6))/0x7)+-parseInt(_0x56d387(0x1b0))/0x8*(parseInt(_0x56d387(0x18b))/0x9)+-parseInt(_0x56d387(0x1c8))/0xa+-parseInt(_0x56d387(0x27c))/0xb*(parseInt(_0x56d387(0x28c))/0xc);if(_0x1bea0===_0x55001e)break;else _0x14d5b7['push'](_0x14d5b7['shift']());}catch(_0x4d03eb){_0x14d5b7['push'](_0x14d5b7['shift']());}}}(_0xfb8e,0xb7dcf));var label='MapEventEffects',tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x2a107e(0x290)](function(_0x37a475){const _0x2d7b80=_0x2a107e;return _0x37a475[_0x2d7b80(0x257)]&&_0x37a475[_0x2d7b80(0x168)]['includes']('['+label+']');})[0x0];function _0xfb8e(){const _0x351ecd=['Sidestep','Flash_ChangeFor_Player','filter','code','_sidestepChangeDuration','BreathRandomY','includes','RegExp','RepeatAniMuteOn','cycle','_floatChangeDuration','setupPageSettings','FUNC','BreathRandomX','FLlkW','Hue_ChangeFor_Follower','ColorBlue','Cycle','ZXTrp','_breathingSpeedX','ARRAYNUM','BreathRandomBoth','_bushDepth','EVAL','_flashWholeDuration','_floatHeight','_flashCycle','slice','VisuMZ_0_CoreEngine','updateMapEventSidestep','MAP_EVENT_EFFECTS','lqIDw','_tintDuration','FloatRandomOffset','_erased','Flash_ChangeFor_Event','yqZlk','_tintCurrent','command357','initScaleBaseValues','max','description','_breathingChangeSpeedY','Shake_ChangeFor_Player','_breathingRngX','euAMy','RepeatAniMirrorOff','nAsbJ','call','VdiZl','ColorGray','updateMapEventFlashCycle','Sprite_Character_updateOther','SidestepSpeed','STR','flashCycle','setupMapEventEffectsEffects','ARRAYFUNC','updateMapEventFloatHeight','tYcgG','_sidestepMax','getLastPluginCommandInterpreter','ARRAYSTRUCT','_scaleY','WMoNF','_sidestepSpeed','Game_CharacterBase_jumpHeight','_sidestepChangeSpeedTarget','_breathingRateY','_lastShakeGraphicsCountX','SidestepRandomOffset','_tintTarget','mapEventEffectsPreventBushDepth','event','_scaleBaseTargetX','_breathingY','96282OkTdOF','HueRandomBetween','pkwin','updateMapEventHue','processMapEventRepeatAnimation','Sidestep_ChangeFor_Follower','screenZ','updateMapEventSidestepChange','parameters','rXYzs','Hue','_hue','MapEventEffects','note','ColorAlpha','ColorGreen','5521554pIBVtR','EventsMoveCore','XhwGw','FloatSpeed','_scaleBaseTargetY','Sidestep_ChangeFor_Event','_scaleBaseDuration','updateMapEventTintChange','_sidestepRng','bBgzz','Mirror','7gABYNR','HgIrd','_flashDuration','teOwD','eventId','BreathingSpeedY','ShakePower','ScaleX','HueUpdatePerFrame','dhWqr','528CeCIUn','Sidestep_ChangeFor_Player','lmBGY','Duration','startMapEventTintChange','random','_flashStart','_floatHeightMax','update','updateMapEventSidestepDistance','ewsAt','EventID','_floatChangeSpeedTarget','HueRandom','mGwxD','updateMapEventFloat','37242zPjrsJ','floatSpeed','CTPwd','updateBreathingChanges','_breathingRngY','ShakeX','bszeP','vSuEh','206580kpicpD','Tint_ChangeFor_Follower','FollowerID','Scale_ChangeFor_Event','match','_breathingChangeTargetY','format','RepeatAni_ChangeFor_Player','5HODXxi','Scale_ChangeFor_Follower','_floatChangeMinTarget','4325044gBgNcQ','Shake_ChangeFor_Follower','repeatAniCycle','ScaleY','exit','startMapEventScaleChange','repeatAniMirror','sidestepSpeed','registerCommand','Breathing_ChangeFor_Event','Game_Event_setupPageSettings','ZvSJz','BreathStaticBoth','startMapEventFlashChange','updateScaleBase','parse','SypCB','refreshBushDepth','updateMapEventTint','_floatHeightMin','iktwv','prototype','Float_ChangeFor_Follower','changeMapEventRepeatAnimation','FQfHN','applyScaleBaseValues','_breathingChangeTargetX','floatHeightChangeZ','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','Float_ChangeFor_Event','MABge','AnimationID','RepeatAni_ChangeFor_Follower','_breathingChangeSpeedX','BreathRateBoth','RcauX','nayet','BreathingRateX','BAazR','setBlendColor','_scaleX','isSceneMap','Game_CharacterBase_screenX','_sidestepMin','BreathStaticY','FlashColor','Game_CharacterBase_screenZ','QMNsE','Game_CharacterBase_refreshBushDepth','RepeatAni','BreathRateX','toUpperCase','Breathing_ChangeFor_Follower','updateMapEventEffects','Tint_ChangeFor_Player','followers','TintColor','_scene','mirror','startMapEventSidestepChange','clearPageSettings','shakePowerY','1227000CQAkzP','updateOther','dPIxI','Settings','miEGD','applyBreathingCalculations','gVHnJ','74mUeihx','scale','_floatChangeMaxTarget','frameCount','FloatMax','setHue','_sidestepChangeMinTarget','_breathingChangeDuration','min','CucWy','isInstanceOfSceneMap','_floatSpeed','Shake_ChangeFor_Event','split','Scale_ChangeFor_Player','startMapEventFloatChange','_lastHue','BreathingRateY','aBpIt','_breathingX','ONJYQ','BreathRateY','Game_CharacterBase_initMembers','txhcD','list','breathingSpeedX','flashDuration','Sprite_Character_update','startMapEventBreathingChange','return\x200','Flash_ChangeFor_Follower','hqHHn','_repeatAnimation','setupMapEventEffectsNotetags','cos','_breathingRateX','default','_shakePowerX','randomInt','RepeatCycle','name','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','constructor','SidestepMin','setColorTone','updateMapEventFlash','follower','updateMapEventRepeatAnimation','bovqc','_lastShakeX','_hueUpdatePerFrame','Hue_ChangeFor_Player','Breathing_ChangeFor_Player','breathingSpeedY','STRUCT','Game_CharacterBase_update','in\x20order\x20for\x20VisuMZ_4_MapEventEffects\x20to\x20work.','pbfGm','ConvertParams','BreathingSpeedX','nWCDV','ColorRed','mute','status','screenX','_breathingSpeedY','_lastPluginCommandInterpreter','KYiOY','_sidestepChangeMaxTarget','_sidestep','updateMapEventFloatChange','_shakePowerY','abs','Game_Interpreter_PluginCommand','RepeatAni_ChangeFor_Event','ShakePowerX','updateMapEventHueChange','jumpHeight','initMapEventEffectsEffects','SidestepMax','Game_Event_clearPageSettings','iDQRm','VisuMZ_1_EventsMoveCore','_scaleBaseY','JSON','FloatStaticOffset','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','MkRLm','wKSxe','sidestepX','ScaleBaseX','BreathSpeedX','SQyGN','applyBreathingScaleValues','map','setLastPluginCommandInterpreter','updateMapEventFlashChange','_scaleBaseX','_character','Hue_ChangeFor_Event','305965lAVIWP','ScaleBaseY','_floatRng','clamp','BreathSpeedBoth','SidestepBetween','_flashCurrent','Mute','FloatMin','YTxQl','updateMapEventFlashColor','FyfWs','checkMapEventEffectsStringTags','FloatTo','clone','initMembers','996FVbmgE','repeatAniMute'];_0xfb8e=function(){return _0x351ecd;};return _0xfb8e();}VisuMZ[label][_0x2a107e(0x214)]=VisuMZ[label][_0x2a107e(0x214)]||{},VisuMZ[_0x2a107e(0x252)]=function(_0x346ec5,_0x2af623){const _0x263d23=_0x2a107e;for(const _0x3b6c60 in _0x2af623){if(_0x3b6c60['match'](/(.*):(.*)/i)){if(_0x263d23(0x16e)!==_0x263d23(0x16e)){if(!this[_0x263d23(0x25d)])return 0x0;return _0x3810fb['round'](this[_0x263d23(0x25d)]);}else{const _0x29a69a=String(RegExp['$1']),_0x11a8cb=String(RegExp['$2'])[_0x263d23(0x206)]()['trim']();let _0x113796,_0x28ee40,_0x54dbd8;switch(_0x11a8cb){case'NUM':_0x113796=_0x2af623[_0x3b6c60]!==''?Number(_0x2af623[_0x3b6c60]):0x0;break;case _0x263d23(0x153):_0x28ee40=_0x2af623[_0x3b6c60]!==''?JSON['parse'](_0x2af623[_0x3b6c60]):[],_0x113796=_0x28ee40[_0x263d23(0x276)](_0x36480d=>Number(_0x36480d));break;case _0x263d23(0x156):_0x113796=_0x2af623[_0x3b6c60]!==''?eval(_0x2af623[_0x3b6c60]):null;break;case'ARRAYEVAL':_0x28ee40=_0x2af623[_0x3b6c60]!==''?JSON[_0x263d23(0x1e2)](_0x2af623[_0x3b6c60]):[],_0x113796=_0x28ee40[_0x263d23(0x276)](_0xfa2263=>eval(_0xfa2263));break;case _0x263d23(0x26c):_0x113796=_0x2af623[_0x3b6c60]!==''?JSON['parse'](_0x2af623[_0x3b6c60]):'';break;case'ARRAYJSON':_0x28ee40=_0x2af623[_0x3b6c60]!==''?JSON[_0x263d23(0x1e2)](_0x2af623[_0x3b6c60]):[],_0x113796=_0x28ee40[_0x263d23(0x276)](_0x364a21=>JSON[_0x263d23(0x1e2)](_0x364a21));break;case _0x263d23(0x14b):_0x113796=_0x2af623[_0x3b6c60]!==''?new Function(JSON[_0x263d23(0x1e2)](_0x2af623[_0x3b6c60])):new Function(_0x263d23(0x235));break;case _0x263d23(0x178):_0x28ee40=_0x2af623[_0x3b6c60]!==''?JSON[_0x263d23(0x1e2)](_0x2af623[_0x3b6c60]):[],_0x113796=_0x28ee40[_0x263d23(0x276)](_0x309ee5=>new Function(JSON['parse'](_0x309ee5)));break;case _0x263d23(0x175):_0x113796=_0x2af623[_0x3b6c60]!==''?String(_0x2af623[_0x3b6c60]):'';break;case'ARRAYSTR':_0x28ee40=_0x2af623[_0x3b6c60]!==''?JSON[_0x263d23(0x1e2)](_0x2af623[_0x3b6c60]):[],_0x113796=_0x28ee40[_0x263d23(0x276)](_0xe52fa5=>String(_0xe52fa5));break;case _0x263d23(0x24e):_0x54dbd8=_0x2af623[_0x3b6c60]!==''?JSON[_0x263d23(0x1e2)](_0x2af623[_0x3b6c60]):{},_0x113796=VisuMZ[_0x263d23(0x252)]({},_0x54dbd8);break;case _0x263d23(0x17d):_0x28ee40=_0x2af623[_0x3b6c60]!==''?JSON[_0x263d23(0x1e2)](_0x2af623[_0x3b6c60]):[],_0x113796=_0x28ee40['map'](_0xe9e21=>VisuMZ[_0x263d23(0x252)]({},JSON[_0x263d23(0x1e2)](_0xe9e21)));break;default:continue;}_0x346ec5[_0x29a69a]=_0x113796;}}}return _0x346ec5;},(_0x36d4d0=>{const _0x3c8cba=_0x2a107e,_0xa2f088=_0x36d4d0[_0x3c8cba(0x240)];for(const _0x39ba2f of dependencies){if(_0x3c8cba(0x274)===_0x3c8cba(0x274)){if(!Imported[_0x39ba2f]){alert(_0x3c8cba(0x1ef)[_0x3c8cba(0x1ce)](_0xa2f088,_0x39ba2f)),SceneManager[_0x3c8cba(0x1d7)]();break;}}else _0x1f33c8[_0x3c8cba(0x197)][_0x3c8cba(0x1dd)][_0x3c8cba(0x16f)](this),this[_0x3c8cba(0x177)]();}const _0x19dda2=_0x36d4d0['description'];if(_0x19dda2['match'](/\[Version[ ](.*?)\]/i)){if(_0x3c8cba(0x1a7)!==_0x3c8cba(0x17a)){const _0x3da543=Number(RegExp['$1']);_0x3da543!==VisuMZ[label]['version']&&('YVcGr'!=='YVcGr'?this[_0x3c8cba(0x158)]>=_0x5ecf50[_0x3c8cba(0x15d)][_0x3c8cba(0x1ee)]&&(_0x236f3f=_0x31153f[_0x3c8cba(0x167)](_0x5181be,0x5)):(alert(_0x3c8cba(0x26e)['format'](_0xa2f088,_0x3da543)),SceneManager[_0x3c8cba(0x1d7)]()));}else{const _0x2af49e=_0x5256fc(_0x10b7b5['$1']),_0x414a7e=_0x10bb78(_0x25bb69['$2']);this[_0x3c8cba(0x25d)]=_0x2acd26[_0x3c8cba(0x220)](_0x2af49e,_0x414a7e),this[_0x3c8cba(0x1fe)]=_0x263471['min'](_0x2af49e,_0x414a7e),this[_0x3c8cba(0x17b)]=_0x247a76[_0x3c8cba(0x167)](_0x2af49e,_0x414a7e),this[_0x3c8cba(0x21e)]=this[_0x3c8cba(0x1fe)],this[_0x3c8cba(0x25c)]=this[_0x3c8cba(0x17b)];}}if(_0x19dda2[_0x3c8cba(0x1cc)](/\[Tier[ ](\d+)\]/i)){const _0x391250=Number(RegExp['$1']);if(_0x391250<tier)'XhwGw'!==_0x3c8cba(0x19d)?_0x31f73e[_0x3c8cba(0x197)][_0x3c8cba(0x203)][_0x3c8cba(0x16f)](this):(alert(_0x3c8cba(0x241)['format'](_0xa2f088,_0x391250,tier)),SceneManager[_0x3c8cba(0x1d7)]());else{if(_0x3c8cba(0x18d)!==_0x3c8cba(0x248))tier=Math['max'](_0x391250,tier);else{if(!this[_0x3c8cba(0x27a)][_0x3c8cba(0x282)])return;this[_0x3c8cba(0x1fa)](this['_character'][_0x3c8cba(0x282)]);}}}VisuMZ[_0x3c8cba(0x252)](VisuMZ[label][_0x3c8cba(0x214)],_0x36d4d0[_0x3c8cba(0x193)]);})(pluginData);if(VisuMZ[_0x2a107e(0x19c)]&&VisuMZ[_0x2a107e(0x19c)]['version']<1.49){let text='';text+='VisuMZ_1_EventsMoveCore\x20needs\x20to\x20be\x20updated\x20',text+=_0x2a107e(0x250),alert(text),SceneManager[_0x2a107e(0x1d7)]();}function _0xfdf3(_0x5e03fa,_0x197e0c){const _0xfb8e78=_0xfb8e();return _0xfdf3=function(_0xfdf337,_0x403b85){_0xfdf337=_0xfdf337-0x14a;let _0x1490f1=_0xfb8e78[_0xfdf337];return _0x1490f1;},_0xfdf3(_0x5e03fa,_0x197e0c);}PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1dc),_0x335a35=>{const _0x5a58e6=_0x2a107e;if(!SceneManager[_0x5a58e6(0x222)]())return;VisuMZ[_0x5a58e6(0x252)](_0x335a35,_0x335a35);const _0x44d28a=$gameTemp['getLastPluginCommandInterpreter'](),_0x3fc66b=_0x335a35['EventID']||_0x44d28a[_0x5a58e6(0x1aa)](),_0x2adce9=$gameMap['event'](_0x3fc66b);if(!_0x2adce9)return;const _0x196596=_0x335a35[_0x5a58e6(0x1f8)]||0x0,_0xe4c81c=_0x335a35[_0x5a58e6(0x229)]||0x0,_0x5650ba=_0x335a35[_0x5a58e6(0x253)]??(_0x2adce9[_0x5a58e6(0x152)]||0.01),_0x2c91ca=_0x335a35[_0x5a58e6(0x1ab)]??(_0x2adce9[_0x5a58e6(0x259)]||0.01),_0x58f347=_0x335a35[_0x5a58e6(0x1b3)]??0x0;_0x2adce9[_0x5a58e6(0x234)](_0x196596,_0xe4c81c,_0x5650ba,_0x2c91ca,_0x58f347);}),PluginManager['registerCommand'](pluginData[_0x2a107e(0x240)],_0x2a107e(0x207),_0x845b23=>{const _0x3c7417=_0x2a107e;if(!SceneManager[_0x3c7417(0x222)]())return;VisuMZ['ConvertParams'](_0x845b23,_0x845b23);const _0x5a28f5=(_0x845b23[_0x3c7417(0x1ca)]||0x0)-0x1,_0x2e537b=$gamePlayer['followers']()[_0x3c7417(0x246)](_0x5a28f5);if(!_0x2e537b)return;const _0x116f18=_0x845b23['BreathingRateX']||0x0,_0x1785ec=_0x845b23['BreathingRateY']||0x0,_0x1b1700=_0x845b23[_0x3c7417(0x253)]??(_0x2e537b['_breathingSpeedX']||0.01),_0x512fcc=_0x845b23['BreathingSpeedY']??(_0x2e537b[_0x3c7417(0x259)]||0.01),_0x18ddbb=_0x845b23[_0x3c7417(0x1b3)]??0x0;_0x2e537b[_0x3c7417(0x234)](_0x116f18,_0x1785ec,_0x1b1700,_0x512fcc,_0x18ddbb);}),PluginManager['registerCommand'](pluginData['name'],_0x2a107e(0x24c),_0x14d296=>{const _0x2c23aa=_0x2a107e;if(!SceneManager[_0x2c23aa(0x222)]())return;VisuMZ[_0x2c23aa(0x252)](_0x14d296,_0x14d296);const _0x24305d=$gamePlayer,_0x31ea0e=_0x14d296[_0x2c23aa(0x1f8)]||0x0,_0x3f9824=_0x14d296[_0x2c23aa(0x229)]||0x0,_0x3289d1=_0x14d296[_0x2c23aa(0x253)]??(_0x24305d[_0x2c23aa(0x152)]||0.01),_0x473bf7=_0x14d296[_0x2c23aa(0x1ab)]??(_0x24305d[_0x2c23aa(0x259)]||0.01),_0xb72fe8=_0x14d296[_0x2c23aa(0x1b3)]??0x0;_0x24305d[_0x2c23aa(0x234)](_0x31ea0e,_0x3f9824,_0x3289d1,_0x473bf7,_0xb72fe8);}),PluginManager[_0x2a107e(0x1db)](pluginData['name'],_0x2a107e(0x162),_0xc85709=>{const _0x3326cb=_0x2a107e;if(!SceneManager[_0x3326cb(0x222)]())return;VisuMZ[_0x3326cb(0x252)](_0xc85709,_0xc85709);const _0x186b31=$gameTemp['getLastPluginCommandInterpreter'](),_0x290464=_0xc85709[_0x3326cb(0x1bb)]||_0x186b31[_0x3326cb(0x1aa)](),_0x341683=$gameMap[_0x3326cb(0x188)](_0x290464);if(!_0x341683)return;const _0xaf6077=[(_0xc85709[_0x3326cb(0x255)]||0x0)['clamp'](0x0,0xff),(_0xc85709[_0x3326cb(0x19a)]||0x0)[_0x3326cb(0x27f)](0x0,0xff),(_0xc85709[_0x3326cb(0x14f)]||0x0)[_0x3326cb(0x27f)](0x0,0xff),(_0xc85709['ColorAlpha']||0x0)[_0x3326cb(0x27f)](0x0,0xff)],_0xcc6287=_0xc85709[_0x3326cb(0x1b3)]??0x0,_0x23a4fc=_0xc85709[_0x3326cb(0x150)]??0x0;_0x341683['startMapEventFlashChange'](_0xaf6077,_0xcc6287,_0x23a4fc);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x236),_0x514256=>{const _0x54e62b=_0x2a107e;if(!SceneManager[_0x54e62b(0x222)]())return;VisuMZ[_0x54e62b(0x252)](_0x514256,_0x514256);const _0x50b7b9=(_0x514256[_0x54e62b(0x1ca)]||0x0)-0x1,_0x2aedea=$gamePlayer[_0x54e62b(0x20a)]()['follower'](_0x50b7b9);if(!_0x2aedea)return;const _0x2c999d=[(_0x514256[_0x54e62b(0x255)]||0x0)[_0x54e62b(0x27f)](0x0,0xff),(_0x514256[_0x54e62b(0x19a)]||0x0)['clamp'](0x0,0xff),(_0x514256[_0x54e62b(0x14f)]||0x0)[_0x54e62b(0x27f)](0x0,0xff),(_0x514256[_0x54e62b(0x199)]||0x0)[_0x54e62b(0x27f)](0x0,0xff)],_0x3990ec=_0x514256['Duration']??0x0,_0x146830=_0x514256['Cycle']??0x0;_0x2aedea[_0x54e62b(0x1e0)](_0x2c999d,_0x3990ec,_0x146830);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x28f),_0x4c5854=>{const _0x465a16=_0x2a107e;if(!SceneManager[_0x465a16(0x222)]())return;VisuMZ[_0x465a16(0x252)](_0x4c5854,_0x4c5854);const _0x268fde=$gamePlayer,_0x1b6ec1=[(_0x4c5854[_0x465a16(0x255)]||0x0)['clamp'](0x0,0xff),(_0x4c5854['ColorGreen']||0x0)[_0x465a16(0x27f)](0x0,0xff),(_0x4c5854[_0x465a16(0x14f)]||0x0)[_0x465a16(0x27f)](0x0,0xff),(_0x4c5854[_0x465a16(0x199)]||0x0)[_0x465a16(0x27f)](0x0,0xff)],_0x4ead21=_0x4c5854[_0x465a16(0x1b3)]??0x0,_0x319916=_0x4c5854[_0x465a16(0x150)]??0x0;_0x268fde[_0x465a16(0x1e0)](_0x1b6ec1,_0x4ead21,_0x319916);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1f0),_0x1d70a2=>{const _0x5de518=_0x2a107e;if(!SceneManager[_0x5de518(0x222)]())return;VisuMZ['ConvertParams'](_0x1d70a2,_0x1d70a2);const _0x2dcec2=$gameTemp[_0x5de518(0x17c)](),_0x94de1a=_0x1d70a2[_0x5de518(0x1bb)]||_0x2dcec2[_0x5de518(0x1aa)](),_0x524b0a=$gameMap[_0x5de518(0x188)](_0x94de1a);if(!_0x524b0a)return;const _0x505b12=Math[_0x5de518(0x220)](_0x1d70a2[_0x5de518(0x284)]||0x0,_0x1d70a2[_0x5de518(0x21c)]||0x0),_0x599711=Math[_0x5de518(0x167)](_0x1d70a2[_0x5de518(0x284)]||0x0,_0x1d70a2[_0x5de518(0x21c)]||0x0),_0x72dcf8=_0x1d70a2[_0x5de518(0x19e)]??(_0x524b0a[_0x5de518(0x223)]||0.01),_0x1eb32d=_0x1d70a2[_0x5de518(0x1b3)]??0x0;_0x524b0a[_0x5de518(0x227)](_0x505b12,_0x599711,_0x72dcf8,_0x1eb32d);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1e9),_0x28a867=>{const _0x4050aa=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ[_0x4050aa(0x252)](_0x28a867,_0x28a867);const _0x1c7193=(_0x28a867[_0x4050aa(0x1ca)]||0x0)-0x1,_0x135b78=$gamePlayer['followers']()[_0x4050aa(0x246)](_0x1c7193);if(!_0x135b78)return;const _0x57ec50=Math[_0x4050aa(0x220)](_0x28a867[_0x4050aa(0x284)]||0x0,_0x28a867['FloatMax']||0x0),_0x38e6af=Math[_0x4050aa(0x167)](_0x28a867[_0x4050aa(0x284)]||0x0,_0x28a867[_0x4050aa(0x21c)]||0x0),_0x39844a=_0x28a867['FloatSpeed']??(_0x135b78[_0x4050aa(0x223)]||0.01),_0x3972a7=_0x28a867[_0x4050aa(0x1b3)]??0x0;_0x135b78[_0x4050aa(0x227)](_0x57ec50,_0x38e6af,_0x39844a,_0x3972a7);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],'Float_ChangeFor_Player',_0x3bc1d4=>{const _0x4efc09=_0x2a107e;if(!SceneManager[_0x4efc09(0x222)]())return;VisuMZ[_0x4efc09(0x252)](_0x3bc1d4,_0x3bc1d4);const _0x53b472=$gamePlayer,_0x2d5335=Math[_0x4efc09(0x220)](_0x3bc1d4[_0x4efc09(0x284)]||0x0,_0x3bc1d4['FloatMax']||0x0),_0x3a52aa=Math[_0x4efc09(0x167)](_0x3bc1d4[_0x4efc09(0x284)]||0x0,_0x3bc1d4[_0x4efc09(0x21c)]||0x0),_0x18e09f=_0x3bc1d4['FloatSpeed']??(_0x53b472[_0x4efc09(0x223)]||0.01),_0x4629e9=_0x3bc1d4['Duration']??0x0;_0x53b472[_0x4efc09(0x227)](_0x2d5335,_0x3a52aa,_0x18e09f,_0x4629e9);}),PluginManager['registerCommand'](pluginData[_0x2a107e(0x240)],_0x2a107e(0x27b),_0x5552d1=>{const _0x19a65a=_0x2a107e;if(!SceneManager[_0x19a65a(0x222)]())return;VisuMZ['ConvertParams'](_0x5552d1,_0x5552d1);const _0x16c40d=$gameTemp[_0x19a65a(0x17c)](),_0x4f8c80=_0x5552d1[_0x19a65a(0x1bb)]||_0x16c40d[_0x19a65a(0x1aa)](),_0x19f1f9=$gameMap[_0x19a65a(0x188)](_0x4f8c80);if(!_0x19f1f9)return;_0x19f1f9[_0x19a65a(0x196)]=_0x5552d1[_0x19a65a(0x195)]||0x0;}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x14e),_0x1076e8=>{const _0x277739=_0x2a107e;if(!SceneManager[_0x277739(0x222)]())return;VisuMZ['ConvertParams'](_0x1076e8,_0x1076e8);const _0x545229=(_0x1076e8[_0x277739(0x1ca)]||0x0)-0x1,_0x2b3f62=$gamePlayer[_0x277739(0x20a)]()[_0x277739(0x246)](_0x545229);if(!_0x2b3f62)return;_0x2b3f62['_hue']=_0x1076e8[_0x277739(0x195)]||0x0;}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x24b),_0x131f1a=>{const _0x49985f=_0x2a107e;if(!SceneManager[_0x49985f(0x222)]())return;VisuMZ[_0x49985f(0x252)](_0x131f1a,_0x131f1a);const _0x36087e=$gamePlayer;_0x36087e[_0x49985f(0x196)]=_0x131f1a[_0x49985f(0x195)]||0x0;}),PluginManager[_0x2a107e(0x1db)](pluginData['name'],_0x2a107e(0x262),_0x8dc6d0=>{const _0x34b0a9=_0x2a107e;if(!SceneManager[_0x34b0a9(0x222)]())return;VisuMZ[_0x34b0a9(0x252)](_0x8dc6d0,_0x8dc6d0);const _0x534143=$gameTemp['getLastPluginCommandInterpreter'](),_0x338245=_0x8dc6d0[_0x34b0a9(0x1bb)]||_0x534143['eventId'](),_0x4b203b=$gameMap[_0x34b0a9(0x188)](_0x338245);if(!_0x4b203b)return;const _0x3b3488=Number(_0x8dc6d0[_0x34b0a9(0x1f2)])||0x0,_0x3638ac=Number(_0x8dc6d0[_0x34b0a9(0x23f)])||0x0,_0x463155=_0x8dc6d0[_0x34b0a9(0x1a5)],_0x5bee15=_0x8dc6d0[_0x34b0a9(0x283)];_0x4b203b[_0x34b0a9(0x1ea)](_0x3b3488,_0x3638ac,_0x463155,_0x5bee15);}),PluginManager['registerCommand'](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1f3),_0x4723c0=>{const _0x52cba9=_0x2a107e;if(!SceneManager[_0x52cba9(0x222)]())return;VisuMZ[_0x52cba9(0x252)](_0x4723c0,_0x4723c0);const _0x498dcb=(_0x4723c0[_0x52cba9(0x1ca)]||0x0)-0x1,_0x3000da=$gamePlayer[_0x52cba9(0x20a)]()[_0x52cba9(0x246)](_0x498dcb);if(!_0x3000da)return;const _0xd4d711=Number(_0x4723c0['AnimationID'])||0x0,_0x480c72=Number(_0x4723c0['RepeatCycle'])||0x0,_0x59f367=_0x4723c0[_0x52cba9(0x1a5)],_0x25d344=_0x4723c0[_0x52cba9(0x283)];_0x3000da[_0x52cba9(0x1ea)](_0xd4d711,_0x480c72,_0x59f367,_0x25d344);}),PluginManager[_0x2a107e(0x1db)](pluginData['name'],_0x2a107e(0x1cf),_0x24e3fb=>{const _0x5590b7=_0x2a107e;if(!SceneManager[_0x5590b7(0x222)]())return;VisuMZ['ConvertParams'](_0x24e3fb,_0x24e3fb);const _0x304e57=$gamePlayer,_0x364096=Number(_0x24e3fb[_0x5590b7(0x1f2)])||0x0,_0x30eb2f=Number(_0x24e3fb['RepeatCycle'])||0x0,_0x5f075a=_0x24e3fb['Mirror'],_0x3f2f6e=_0x24e3fb['Mute'];_0x304e57[_0x5590b7(0x1ea)](_0x364096,_0x30eb2f,_0x5f075a,_0x3f2f6e);}),PluginManager[_0x2a107e(0x1db)](pluginData['name'],_0x2a107e(0x1cb),_0x42d8e2=>{const _0x2bcef5=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ['ConvertParams'](_0x42d8e2,_0x42d8e2);const _0x1a8319=$gameTemp[_0x2bcef5(0x17c)](),_0x43619a=_0x42d8e2[_0x2bcef5(0x1bb)]||_0x1a8319[_0x2bcef5(0x1aa)](),_0x121a7c=$gameMap[_0x2bcef5(0x188)](_0x43619a);if(!_0x121a7c)return;const _0x197116=_0x42d8e2[_0x2bcef5(0x1ad)]||0x0,_0x4eb4f8=_0x42d8e2[_0x2bcef5(0x1d6)]||0x0,_0x525b22=_0x42d8e2[_0x2bcef5(0x1b3)]??0x0;_0x121a7c[_0x2bcef5(0x1d8)](_0x197116,_0x4eb4f8,_0x525b22);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1d1),_0x200704=>{const _0x20245c=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ[_0x20245c(0x252)](_0x200704,_0x200704);const _0x2f8d0d=(_0x200704[_0x20245c(0x1ca)]||0x0)-0x1,_0x251996=$gamePlayer[_0x20245c(0x20a)]()[_0x20245c(0x246)](_0x2f8d0d);if(!_0x251996)return;const _0x56a08d=_0x200704[_0x20245c(0x1ad)]||0x0,_0x39205a=_0x200704[_0x20245c(0x1d6)]||0x0,_0x460db2=_0x200704[_0x20245c(0x1b3)]??0x0;_0x251996[_0x20245c(0x1d8)](_0x56a08d,_0x39205a,_0x460db2);}),PluginManager['registerCommand'](pluginData[_0x2a107e(0x240)],_0x2a107e(0x226),_0x428996=>{const _0x2a5c0c=_0x2a107e;if(!SceneManager[_0x2a5c0c(0x222)]())return;VisuMZ['ConvertParams'](_0x428996,_0x428996);const _0x284a4b=$gamePlayer,_0x51ad82=_0x428996['ScaleX']||0x0,_0x561ba9=_0x428996[_0x2a5c0c(0x1d6)]||0x0,_0x289768=_0x428996[_0x2a5c0c(0x1b3)]??0x0;_0x284a4b['startMapEventScaleChange'](_0x51ad82,_0x561ba9,_0x289768);}),PluginManager['registerCommand'](pluginData['name'],_0x2a107e(0x224),_0x804401=>{const _0x4bbd7b=_0x2a107e;if(!SceneManager[_0x4bbd7b(0x222)]())return;VisuMZ[_0x4bbd7b(0x252)](_0x804401,_0x804401);const _0x2cbb41=$gameTemp['getLastPluginCommandInterpreter'](),_0x5dbc5e=_0x804401[_0x4bbd7b(0x1bb)]||_0x2cbb41[_0x4bbd7b(0x1aa)](),_0x47bd9e=$gameMap[_0x4bbd7b(0x188)](_0x5dbc5e);if(!_0x47bd9e)return;_0x47bd9e['_shakePowerX']=Math[_0x4bbd7b(0x260)](_0x804401[_0x4bbd7b(0x1c5)]||0x0),_0x47bd9e[_0x4bbd7b(0x25f)]=Math[_0x4bbd7b(0x260)](_0x804401[_0x4bbd7b(0x1c5)]||0x0);}),PluginManager['registerCommand'](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1d4),_0x486b98=>{const _0x421e6f=_0x2a107e;if(!SceneManager[_0x421e6f(0x222)]())return;VisuMZ[_0x421e6f(0x252)](_0x486b98,_0x486b98);const _0x697a39=(_0x486b98['FollowerID']||0x0)-0x1,_0x4efd2f=$gamePlayer[_0x421e6f(0x20a)]()['follower'](_0x697a39);if(!_0x4efd2f)return;_0x4efd2f[_0x421e6f(0x23d)]=Math['abs'](_0x486b98['ShakeX']||0x0),_0x4efd2f[_0x421e6f(0x25f)]=Math[_0x421e6f(0x260)](_0x486b98[_0x421e6f(0x1c5)]||0x0);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x16a),_0x1b3622=>{const _0x2bbb98=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ[_0x2bbb98(0x252)](_0x1b3622,_0x1b3622);const _0x3acb7d=$gamePlayer;_0x3acb7d['_shakePowerX']=Math['abs'](_0x1b3622[_0x2bbb98(0x1c5)]||0x0),_0x3acb7d[_0x2bbb98(0x25f)]=Math['abs'](_0x1b3622[_0x2bbb98(0x1c5)]||0x0);}),PluginManager['registerCommand'](pluginData['name'],_0x2a107e(0x1a0),_0x2f5e57=>{const _0x39e6c6=_0x2a107e;if(!SceneManager[_0x39e6c6(0x222)]())return;VisuMZ['ConvertParams'](_0x2f5e57,_0x2f5e57);const _0x4a0599=$gameTemp['getLastPluginCommandInterpreter'](),_0x584371=_0x2f5e57[_0x39e6c6(0x1bb)]||_0x4a0599[_0x39e6c6(0x1aa)](),_0x52412f=$gameMap['event'](_0x584371);if(!_0x52412f)return;const _0x368900=Math[_0x39e6c6(0x220)](_0x2f5e57['SidestepMin']||0x0,_0x2f5e57[_0x39e6c6(0x267)]||0x0),_0x8ce4d3=Math[_0x39e6c6(0x167)](_0x2f5e57[_0x39e6c6(0x243)]||0x0,_0x2f5e57[_0x39e6c6(0x267)]||0x0),_0x575182=_0x2f5e57['SidestepSpeed']??(_0x52412f[_0x39e6c6(0x180)]||0.01),_0x33d157=_0x2f5e57['Duration']??0x0;_0x52412f[_0x39e6c6(0x20e)](_0x368900,_0x8ce4d3,_0x575182,_0x33d157);}),PluginManager[_0x2a107e(0x1db)](pluginData['name'],_0x2a107e(0x190),_0xac7615=>{const _0x3fcb18=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ['ConvertParams'](_0xac7615,_0xac7615);const _0x27687a=(_0xac7615[_0x3fcb18(0x1ca)]||0x0)-0x1,_0x4b6a87=$gamePlayer[_0x3fcb18(0x20a)]()[_0x3fcb18(0x246)](_0x27687a);if(!_0x4b6a87)return;const _0x492900=Math[_0x3fcb18(0x220)](_0xac7615['SidestepMin']||0x0,_0xac7615[_0x3fcb18(0x267)]||0x0),_0x4a13dc=Math[_0x3fcb18(0x167)](_0xac7615[_0x3fcb18(0x243)]||0x0,_0xac7615[_0x3fcb18(0x267)]||0x0),_0x1a132c=_0xac7615[_0x3fcb18(0x174)]??(_0x4b6a87[_0x3fcb18(0x180)]||0.01),_0x5275b2=_0xac7615[_0x3fcb18(0x1b3)]??0x0;_0x4b6a87['startMapEventSidestepChange'](_0x492900,_0x4a13dc,_0x1a132c,_0x5275b2);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1b1),_0x17c188=>{const _0x3c11c5=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ[_0x3c11c5(0x252)](_0x17c188,_0x17c188);const _0x2264a5=$gamePlayer,_0xb4089a=Math[_0x3c11c5(0x220)](_0x17c188[_0x3c11c5(0x243)]||0x0,_0x17c188[_0x3c11c5(0x267)]||0x0),_0x1bc933=Math['max'](_0x17c188[_0x3c11c5(0x243)]||0x0,_0x17c188['SidestepMax']||0x0),_0x424988=_0x17c188[_0x3c11c5(0x174)]??(_0x2264a5[_0x3c11c5(0x180)]||0.01),_0x205127=_0x17c188[_0x3c11c5(0x1b3)]??0x0;_0x2264a5[_0x3c11c5(0x20e)](_0xb4089a,_0x1bc933,_0x424988,_0x205127);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],'Tint_ChangeFor_Event',_0x50b74e=>{const _0x11e56e=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ[_0x11e56e(0x252)](_0x50b74e,_0x50b74e);const _0x457e40=$gameTemp['getLastPluginCommandInterpreter'](),_0x4f5f83=_0x50b74e[_0x11e56e(0x1bb)]||_0x457e40[_0x11e56e(0x1aa)](),_0x2be30a=$gameMap[_0x11e56e(0x188)](_0x4f5f83);if(!_0x2be30a)return;const _0x2f501d=[(_0x50b74e[_0x11e56e(0x255)]||0x0)[_0x11e56e(0x27f)](-0xff,0xff),(_0x50b74e['ColorGreen']||0x0)[_0x11e56e(0x27f)](-0xff,0xff),(_0x50b74e[_0x11e56e(0x14f)]||0x0)[_0x11e56e(0x27f)](-0xff,0xff),(_0x50b74e[_0x11e56e(0x171)]||0x0)[_0x11e56e(0x27f)](0x0,0xff)],_0x4380ef=_0x50b74e[_0x11e56e(0x1b3)]??0x0;_0x2be30a['startMapEventTintChange'](_0x2f501d,_0x4380ef);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x1c9),_0x49b5b9=>{const _0x4d652c=_0x2a107e;if(!SceneManager[_0x4d652c(0x222)]())return;VisuMZ['ConvertParams'](_0x49b5b9,_0x49b5b9);const _0x417855=(_0x49b5b9[_0x4d652c(0x1ca)]||0x0)-0x1,_0x1d9002=$gamePlayer[_0x4d652c(0x20a)]()[_0x4d652c(0x246)](_0x417855);if(!_0x1d9002)return;const _0x4a637d=[(_0x49b5b9['ColorRed']||0x0)[_0x4d652c(0x27f)](-0xff,0xff),(_0x49b5b9['ColorGreen']||0x0)['clamp'](-0xff,0xff),(_0x49b5b9['ColorBlue']||0x0)['clamp'](-0xff,0xff),(_0x49b5b9[_0x4d652c(0x171)]||0x0)[_0x4d652c(0x27f)](0x0,0xff)],_0x413268=_0x49b5b9[_0x4d652c(0x1b3)]??0x0;_0x1d9002['startMapEventTintChange'](_0x4a637d,_0x413268);}),PluginManager[_0x2a107e(0x1db)](pluginData[_0x2a107e(0x240)],_0x2a107e(0x209),_0x387773=>{const _0x1e7df4=_0x2a107e;if(!SceneManager['isInstanceOfSceneMap']())return;VisuMZ[_0x1e7df4(0x252)](_0x387773,_0x387773);const _0x53fa69=$gamePlayer,_0x48134e=[(_0x387773[_0x1e7df4(0x255)]||0x0)['clamp'](-0xff,0xff),(_0x387773['ColorGreen']||0x0)[_0x1e7df4(0x27f)](-0xff,0xff),(_0x387773[_0x1e7df4(0x14f)]||0x0)[_0x1e7df4(0x27f)](-0xff,0xff),(_0x387773['ColorGray']||0x0)[_0x1e7df4(0x27f)](0x0,0xff)],_0x23550f=_0x387773[_0x1e7df4(0x1b3)]??0x0;_0x53fa69[_0x1e7df4(0x1b4)](_0x48134e,_0x23550f);}),VisuMZ['MapEventEffects']['RegExp']={'Float':/<FLOAT HEIGHT:[ ](\d+)>/i,'FloatTo':/<FLOAT HEIGHT:[ ](.*?) TO (.*?)>/i,'FloatSpeed':/<FLOAT SPEED:[ ](.*?)>/i,'FloatRandomOffset':/<FLOAT RANDOM OFFSET>/i,'FloatStaticOffset':/<FLOAT STATIC OFFSET:[ ](\d+)>/i,'Sidestep':/<SIDESTEP:[ ]([\+\-]\d+)>/i,'SidestepBetween':/<SIDESTEP:[ ](.*?) TO (.*?)>/i,'SidestepSpeed':/<SIDESTEP SPEED:[ ](.*?)>/i,'SidestepRandomOffset':/<SIDESTEP RANDOM OFFSET>/i,'SidestepStatic':/<SIDESTEP STATIC OFFSET:[ ](\d+)>/i,'Hue':/<HUE:[ ](\d+)>/i,'HueRandom':/<RANDOM HUE>/i,'HueRandomBetween':/<RANDOM HUE:[ ](\d+) TO (\d+)>/i,'HueUpdatePerFrame':/<HUE PER FRAME:[ ]([\+\-]\d+)>/i,'ShakePowerX':/<SHAKE X POWER:[ ](\d+)>/i,'ShakePowerY':/<SHAKE Y POWER:[ ](\d+)>/i,'ShakePower':/<SHAKE POWER:[ ](\d+)>/i,'ScaleBaseX':/<SCALE X:[ ](\d+)([%％])>/i,'ScaleBaseY':/<SCALE Y:[ ](\d+)([%％])>/i,'ScaleBaseBoth':/<SCALE:[ ](\d+)([%％])>/i,'BreathRateX':/<(?:BREATHING) RATE X:[ ](\d+)([%％])>/i,'BreathRateY':/<(?:BREATHING) RATE Y:[ ](\d+)([%％])>/i,'BreathRateBoth':/<(?:BREATHING) RATE:[ ](\d+)([%％])>/i,'BreathSpeedX':/<(?:BREATHING) SPEED X:[ ](.*?)>/i,'BreathSpeedY':/<(?:BREATHING) SPEED Y:[ ](.*?)>/i,'BreathSpeedBoth':/<(?:BREATHING) SPEED:[ ](.*?)>/i,'BreathRandomX':/<(?:BREATHING) RANDOM OFFSET X>/i,'BreathRandomY':/<(?:BREATHING) RANDOM OFFSET Y>/i,'BreathRandomBoth':/<(?:BREATHING) RANDOM OFFSET>/i,'BreathStaticX':/<(?:BREATHING) STATIC OFFSET X:[ ](\d+)>/i,'BreathStaticY':/<(?:BREATHING) STATIC OFFSET Y:[ ](\d+)>/i,'BreathStaticBoth':/<(?:BREATHING) STATIC OFFSET:[ ](\d+)>/i,'TintColor':/<TINT COLOR:[ ](.*?)>/i,'FlashColor':/<FLASH COLOR:[ ](.*?)>/i,'FlashDuration':/<FLASH DURATION:[ ](\d+)>/i,'FlashCycle':/<FLASH CYCLE:[ ](\d+)>/i,'RepeatAni':/<REPEAT ANIMATION:[ ](\d+)>/i,'RepeatAniCycle':/<REPEAT ANIMATION CYCLE:[ ](\d+)>/i,'RepeatAniMirrorOn':/<REPEAT ANIMATION MIRROR:[ ]ON>/i,'RepeatAniMirrorOff':/<REPEAT ANIMATION MIRROR:[ ]OFF>/i,'RepeatAniMuteOn':/<REPEAT ANIMATION MUTE:[ ]ON>/i,'RepeatAniMuteOff':/<REPEAT ANIMATION MUTE:[ ]OFF>/i},SceneManager[_0x2a107e(0x1fc)]=function(){const _0x2dcf8b=_0x2a107e;return this[_0x2dcf8b(0x20c)]&&this[_0x2dcf8b(0x20c)][_0x2dcf8b(0x242)]===Scene_Map;},SceneManager[_0x2a107e(0x222)]=function(){const _0x563326=_0x2a107e;return this['_scene']&&this[_0x563326(0x20c)]instanceof Scene_Map;},Game_Temp[_0x2a107e(0x1e8)][_0x2a107e(0x277)]=function(_0x64f81e){const _0x1c5b3b=_0x2a107e;this[_0x1c5b3b(0x25a)]=_0x64f81e;},Game_Temp['prototype']['getLastPluginCommandInterpreter']=function(){const _0x57b069=_0x2a107e;return this[_0x57b069(0x25a)];},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x261)]=Game_Interpreter['prototype'][_0x2a107e(0x165)],Game_Interpreter[_0x2a107e(0x1e8)][_0x2a107e(0x165)]=function(_0x3137aa){const _0x33bba0=_0x2a107e;return $gameTemp[_0x33bba0(0x277)](this),VisuMZ[_0x33bba0(0x197)][_0x33bba0(0x261)][_0x33bba0(0x16f)](this,_0x3137aa);},VisuMZ[_0x2a107e(0x197)]['Game_CharacterBase_initMembers']=Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x28b)],Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x28b)]=function(){const _0x2dd7a8=_0x2a107e;VisuMZ['MapEventEffects'][_0x2dd7a8(0x22e)][_0x2dd7a8(0x16f)](this),this['initMapEventEffectsEffects']();},Game_CharacterBase[_0x2a107e(0x1e8)]['initMapEventEffectsEffects']=function(){const _0x5e3295=_0x2a107e;this[_0x5e3295(0x158)]=0x0,this['_floatHeightMin']=0x0,this['_floatHeightMax']=0x0,this[_0x5e3295(0x223)]=Game_Event['MAP_EVENT_EFFECTS'][_0x5e3295(0x23c)][_0x5e3295(0x1c1)],this[_0x5e3295(0x27e)]=Math['randomInt'](0xf4240),this[_0x5e3295(0x298)]=0x0,this[_0x5e3295(0x1d2)]=0x0,this['_floatChangeMaxTarget']=0x0,this['_floatChangeSpeedTarget']=this[_0x5e3295(0x223)],this[_0x5e3295(0x25d)]=0x0,this[_0x5e3295(0x1fe)]=0x0,this[_0x5e3295(0x17b)]=0x0,this['_sidestepSpeed']=Game_Event['MAP_EVENT_EFFECTS'][_0x5e3295(0x23c)]['sidestepSpeed'],this['_sidestepRng']=Math[_0x5e3295(0x23e)](0xf4240),this[_0x5e3295(0x292)]=0x0,this['_sidestepChangeMinTarget']=0x0,this[_0x5e3295(0x25c)]=0x0,this['_sidestepChangeSpeedTarget']=this[_0x5e3295(0x180)],this[_0x5e3295(0x196)]=this[_0x5e3295(0x196)]||0x0,this[_0x5e3295(0x24a)]=this[_0x5e3295(0x24a)]||0x0,this[_0x5e3295(0x23d)]=0x0,this[_0x5e3295(0x25f)]=0x0,this[_0x5e3295(0x279)]=0x1,this[_0x5e3295(0x26b)]=0x1,this[_0x5e3295(0x189)]=0x1,this[_0x5e3295(0x19f)]=0x1,this[_0x5e3295(0x1a1)]=0x0,this[_0x5e3295(0x22b)]=0x0,this[_0x5e3295(0x18a)]=0x0,this[_0x5e3295(0x23b)]=0x0,this[_0x5e3295(0x183)]=0x0,this[_0x5e3295(0x152)]=Game_Event[_0x5e3295(0x15d)][_0x5e3295(0x23c)][_0x5e3295(0x231)],this[_0x5e3295(0x259)]=Game_Event[_0x5e3295(0x15d)][_0x5e3295(0x23c)]['breathingSpeedY'],this[_0x5e3295(0x16b)]=Math['randomInt'](0xf4240),this[_0x5e3295(0x1c4)]=Math[_0x5e3295(0x23e)](0xf4240),this[_0x5e3295(0x21f)]=0x0,this['_breathingChangeTargetX']=0x0,this[_0x5e3295(0x1cd)]=0x0,this[_0x5e3295(0x1f4)]=this[_0x5e3295(0x152)],this['_breathingChangeSpeedY']=this['_breathingSpeedY'],this['_tintCurrent']=[0x0,0x0,0x0,0x0],this['_tintTarget']=[0x0,0x0,0x0,0x0],this[_0x5e3295(0x15f)]=0x0,this[_0x5e3295(0x282)]=[0x0,0x0,0x0,0x0],this[_0x5e3295(0x1b6)]=[0x0,0x0,0x0,0x0],this['_flashWholeDuration']=Math['max'](Game_Event[_0x5e3295(0x15d)][_0x5e3295(0x23c)][_0x5e3295(0x232)],0x1),this[_0x5e3295(0x1a8)]=this[_0x5e3295(0x157)],this[_0x5e3295(0x159)]=0x0,this[_0x5e3295(0x238)]={'id':0x0,'cycle':Game_Event[_0x5e3295(0x15d)][_0x5e3295(0x23c)]['repeatAniCycle'],'mirror':Game_Event[_0x5e3295(0x15d)][_0x5e3295(0x23c)][_0x5e3295(0x1d9)],'mute':Game_Event[_0x5e3295(0x15d)][_0x5e3295(0x23c)][_0x5e3295(0x28d)]};},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x1fd)]=Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x258)],Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x258)]=function(){const _0x3b2ce1=_0x2a107e;let _0x5d1953=VisuMZ['MapEventEffects']['Game_CharacterBase_screenX'][_0x3b2ce1(0x16f)](this);if(this[_0x3b2ce1(0x25d)])_0x5d1953+=this[_0x3b2ce1(0x271)]();if(this[_0x3b2ce1(0x23d)])_0x5d1953+=this['shakePowerX']();return _0x5d1953;},VisuMZ['MapEventEffects'][_0x2a107e(0x181)]=Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x265)],Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x265)]=function(){const _0x455b6e=_0x2a107e;let _0x56a423=VisuMZ[_0x455b6e(0x197)][_0x455b6e(0x181)][_0x455b6e(0x16f)](this);if(this['_floatHeight'])_0x56a423+=this['_floatHeight'];if(this['_shakePowerY'])_0x56a423+=this[_0x455b6e(0x210)]();return _0x56a423;},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x24f)]=Game_CharacterBase[_0x2a107e(0x1e8)]['update'],Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x1b8)]=function(){const _0xcbd75f=_0x2a107e;!Imported[_0xcbd75f(0x26a)]&&this[_0xcbd75f(0x1e1)](),VisuMZ[_0xcbd75f(0x197)][_0xcbd75f(0x24f)][_0xcbd75f(0x16f)](this),this[_0xcbd75f(0x208)]();},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x208)]=function(){const _0x4138ac=_0x2a107e;this['updateMapEventFloat'](),this[_0x4138ac(0x15c)](),this[_0x4138ac(0x264)](),this[_0x4138ac(0x1a2)](),this[_0x4138ac(0x286)](),this[_0x4138ac(0x247)]();},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x203)]=Game_CharacterBase['prototype'][_0x2a107e(0x1e4)],Game_CharacterBase[_0x2a107e(0x1e8)]['refreshBushDepth']=function(){const _0x5ee5da=_0x2a107e;if(this[_0x5ee5da(0x187)]())_0x5ee5da(0x1f9)==='VRHkZ'?this[_0x5ee5da(0x238)][_0x5ee5da(0x256)]=!![]:this[_0x5ee5da(0x155)]=0x0;else{if(_0x5ee5da(0x1af)!==_0x5ee5da(0x1af))for(let _0x1cedb3=0x0;_0x1cedb3<=0x3;_0x1cedb3++){_0x148135[_0x1cedb3]=_0x2523e3[_0x1cedb3];}else VisuMZ[_0x5ee5da(0x197)][_0x5ee5da(0x203)][_0x5ee5da(0x16f)](this);}},Game_CharacterBase['prototype'][_0x2a107e(0x187)]=function(){const _0x1d20cd=_0x2a107e;if(this[_0x1d20cd(0x158)])return!![];return![];},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x201)]=Game_CharacterBase['prototype'][_0x2a107e(0x191)],Game_CharacterBase['prototype'][_0x2a107e(0x191)]=function(){const _0x2015d4=_0x2a107e;let _0x27f3f4=VisuMZ['MapEventEffects'][_0x2015d4(0x201)][_0x2015d4(0x16f)](this);return this[_0x2015d4(0x158)]&&(this[_0x2015d4(0x158)]>=Game_Event[_0x2015d4(0x15d)][_0x2015d4(0x1ee)]&&(_0x27f3f4=Math[_0x2015d4(0x167)](_0x27f3f4,0x5))),_0x27f3f4;},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x227)]=function(_0x12ac85,_0x18b264,_0x307592,_0x2ce683){const _0x2bb29e=_0x2a107e;this[_0x2bb29e(0x298)]=_0x2ce683,this['_floatChangeMinTarget']=_0x12ac85,this[_0x2bb29e(0x21a)]=_0x18b264,this[_0x2bb29e(0x1bc)]=_0x307592;if(_0x2ce683<=0x0){if(_0x2bb29e(0x1f1)!==_0x2bb29e(0x1f1)){const _0x5e011a=_0x30699f(_0x450b46['$1']);this[_0x2bb29e(0x16b)]=_0x5e011a,this[_0x2bb29e(0x1c4)]=_0x5e011a;}else this[_0x2bb29e(0x1e6)]=this[_0x2bb29e(0x1d2)],this[_0x2bb29e(0x1b7)]=this[_0x2bb29e(0x21a)],this['_floatSpeed']=this['_floatChangeSpeedTarget'];}},Game_CharacterBase['prototype'][_0x2a107e(0x1bf)]=function(){const _0x11d5f9=_0x2a107e;this['updateMapEventFloatChange'](),this[_0x11d5f9(0x179)]();},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x25e)]=function(){const _0x18e521=_0x2a107e;if(!this[_0x18e521(0x298)])return;this[_0x18e521(0x1e6)]=this['_floatHeightMin']||0x0,this[_0x18e521(0x1b7)]=this['_floatHeightMax']||0x0,this[_0x18e521(0x223)]=this['_floatSpeed']||Game_Event[_0x18e521(0x15d)][_0x18e521(0x23c)][_0x18e521(0x1c1)],this['_floatChangeMinTarget']=this[_0x18e521(0x1d2)]||0x0,this[_0x18e521(0x21a)]=this[_0x18e521(0x21a)]||0x0,this[_0x18e521(0x1bc)]=this[_0x18e521(0x1bc)]||0x0;const _0x2772e1=this[_0x18e521(0x298)];this[_0x18e521(0x1e6)]=(this['_floatHeightMin']*(_0x2772e1-0x1)+this[_0x18e521(0x1d2)])/_0x2772e1,this[_0x18e521(0x1b7)]=(this['_floatHeightMax']*(_0x2772e1-0x1)+this['_floatChangeMaxTarget'])/_0x2772e1,this['_floatSpeed']=(this[_0x18e521(0x223)]*(_0x2772e1-0x1)+this[_0x18e521(0x1bc)])/_0x2772e1,this[_0x18e521(0x298)]--;if(this[_0x18e521(0x298)]<=0x0){if(_0x18e521(0x202)!==_0x18e521(0x254))this[_0x18e521(0x1e6)]=this[_0x18e521(0x1d2)],this[_0x18e521(0x1b7)]=this[_0x18e521(0x21a)],this[_0x18e521(0x223)]=this[_0x18e521(0x1bc)];else{const _0x323b28=_0x39c4cf(_0x5104c8['$1'])*0.01;this[_0x18e521(0x279)]=_0x323b28,this[_0x18e521(0x26b)]=_0x323b28,this[_0x18e521(0x189)]=this[_0x18e521(0x279)],this[_0x18e521(0x19f)]=this[_0x18e521(0x26b)];}}},Game_CharacterBase['prototype']['updateMapEventFloatHeight']=function(){const _0x38fb95=_0x2a107e;this[_0x38fb95(0x158)]=this['_floatHeight']||0x0,this[_0x38fb95(0x1e6)]=this[_0x38fb95(0x1e6)]||0x0,this[_0x38fb95(0x1b7)]=this[_0x38fb95(0x1b7)]||0x0,this[_0x38fb95(0x223)]=this[_0x38fb95(0x223)]||Game_Event['MAP_EVENT_EFFECTS'][_0x38fb95(0x23c)][_0x38fb95(0x1c1)],this[_0x38fb95(0x27e)]=this[_0x38fb95(0x27e)]||Math['randomInt'](0xf4240);if(this[_0x38fb95(0x1e6)]===this['_floatHeightMax']){this['_floatHeight']=this[_0x38fb95(0x1e6)];return;}const _0x25cc3f=(this['_floatHeightMax']-this['_floatHeightMin'])/0x2,_0x3de8b9=Graphics[_0x38fb95(0x21b)]+this['_floatRng'];this[_0x38fb95(0x158)]=this[_0x38fb95(0x1e6)]+Math[_0x38fb95(0x23a)](_0x3de8b9*this['_floatSpeed'])*_0x25cc3f+_0x25cc3f;},Game_CharacterBase[_0x2a107e(0x1e8)]['sidestepX']=function(){const _0x2c118c=_0x2a107e;if(!this['_sidestep'])return 0x0;return Math['round'](this[_0x2c118c(0x25d)]);},Game_CharacterBase[_0x2a107e(0x1e8)]['startMapEventSidestepChange']=function(_0x238bf1,_0x24a388,_0x462a13,_0x3707d1){const _0x129d76=_0x2a107e;this[_0x129d76(0x292)]=_0x3707d1,this[_0x129d76(0x21e)]=_0x238bf1,this[_0x129d76(0x25c)]=_0x24a388,this[_0x129d76(0x182)]=_0x462a13,_0x3707d1<=0x0&&(this[_0x129d76(0x1fe)]=this['_sidestepChangeMinTarget'],this['_sidestepMax']=this[_0x129d76(0x25c)],this[_0x129d76(0x180)]=this[_0x129d76(0x182)]);},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x15c)]=function(){const _0x19788c=_0x2a107e;this[_0x19788c(0x192)](),this[_0x19788c(0x1b9)]();},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x192)]=function(){const _0x3baf7f=_0x2a107e;if(!this['_sidestepChangeDuration'])return;this[_0x3baf7f(0x1fe)]=this[_0x3baf7f(0x1fe)]||0x0,this[_0x3baf7f(0x17b)]=this[_0x3baf7f(0x17b)]||0x0,this[_0x3baf7f(0x180)]=this['_sidestepSpeed']||Game_Event['MAP_EVENT_EFFECTS'][_0x3baf7f(0x23c)]['floatSpeed'],this['_sidestepChangeMinTarget']=this['_sidestepChangeMinTarget']||0x0,this[_0x3baf7f(0x25c)]=this['_sidestepChangeMaxTarget']||0x0,this[_0x3baf7f(0x182)]=this['_sidestepChangeSpeedTarget']||0x0;const _0x41cc56=this[_0x3baf7f(0x292)];this[_0x3baf7f(0x1fe)]=(this[_0x3baf7f(0x1fe)]*(_0x41cc56-0x1)+this['_sidestepChangeMinTarget'])/_0x41cc56,this[_0x3baf7f(0x17b)]=(this['_sidestepMax']*(_0x41cc56-0x1)+this[_0x3baf7f(0x25c)])/_0x41cc56,this[_0x3baf7f(0x180)]=(this['_sidestepSpeed']*(_0x41cc56-0x1)+this['_sidestepChangeSpeedTarget'])/_0x41cc56,this['_sidestepChangeDuration']--,this[_0x3baf7f(0x292)]<=0x0&&(this[_0x3baf7f(0x1fe)]=this['_sidestepChangeMinTarget'],this['_sidestepMax']=this['_sidestepChangeMaxTarget'],this[_0x3baf7f(0x180)]=this[_0x3baf7f(0x182)]);},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x1b9)]=function(){const _0x5e9f76=_0x2a107e;this[_0x5e9f76(0x25d)]=this[_0x5e9f76(0x25d)]||0x0,this[_0x5e9f76(0x1fe)]=this[_0x5e9f76(0x1fe)]||0x0,this[_0x5e9f76(0x17b)]=this['_sidestepMax']||0x0,this[_0x5e9f76(0x180)]=this[_0x5e9f76(0x180)]||Game_Event[_0x5e9f76(0x15d)][_0x5e9f76(0x23c)]['sidestepSpeed'],this[_0x5e9f76(0x1a3)]=this[_0x5e9f76(0x1a3)]||Math[_0x5e9f76(0x23e)](0xf4240);if(this['_sidestepMin']===this[_0x5e9f76(0x17b)]){this[_0x5e9f76(0x25d)]=this[_0x5e9f76(0x1fe)];return;}const _0x129256=(this['_sidestepMax']-this[_0x5e9f76(0x1fe)])/0x2,_0x2a05d8=Graphics[_0x5e9f76(0x21b)]+this[_0x5e9f76(0x1a3)];this[_0x5e9f76(0x25d)]=this[_0x5e9f76(0x1fe)]+Math[_0x5e9f76(0x23a)](_0x2a05d8*this[_0x5e9f76(0x180)])*_0x129256+_0x129256;},Game_CharacterBase['prototype'][_0x2a107e(0x264)]=function(){const _0xdce814=_0x2a107e;this[_0xdce814(0x196)]=this[_0xdce814(0x196)]||0x0,this['_hueUpdatePerFrame']=this[_0xdce814(0x24a)]||0x0,this[_0xdce814(0x24a)]!==0x0&&(this[_0xdce814(0x196)]+=this['_hueUpdatePerFrame']);},Game_CharacterBase[_0x2a107e(0x1e8)]['shakePowerX']=function(){const _0x20b20c=_0x2a107e;if(!this[_0x20b20c(0x23d)])return 0x0;if(this['_lastShakeGraphicsCountX']===Graphics[_0x20b20c(0x21b)])return this[_0x20b20c(0x249)]||0x0;else{if(_0x20b20c(0x1c6)!==_0x20b20c(0x14d))return this[_0x20b20c(0x184)]=Graphics[_0x20b20c(0x21b)],this[_0x20b20c(0x249)]=(Math[_0x20b20c(0x23e)](this['_shakePowerX'])+0x1)*(Math[_0x20b20c(0x1b5)]()<0.5?-0x1:0x1),this['_lastShakeX'];else this['_floatSpeed']=_0x152076(_0x55586c['$1']),this[_0x20b20c(0x1bc)]=this['_floatSpeed'];}},Game_CharacterBase['prototype'][_0x2a107e(0x210)]=function(){const _0x5ec60f=_0x2a107e;if(!this[_0x5ec60f(0x25f)])return 0x0;return Math[_0x5ec60f(0x23e)](this[_0x5ec60f(0x25f)]);},Game_CharacterBase['prototype'][_0x2a107e(0x1e1)]=function(){const _0x3afe8b=_0x2a107e;this['initScaleBaseValues'](),this['updateScaleBaseChanges'](),this[_0x3afe8b(0x1c3)](),this['applyScaleBaseValues'](),this[_0x3afe8b(0x275)]();},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x166)]=function(){const _0x3c6ad2=_0x2a107e;this['_scaleBaseX']=this[_0x3c6ad2(0x279)]??0x1,this[_0x3c6ad2(0x26b)]=this[_0x3c6ad2(0x26b)]??0x1;},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x1d8)]=function(_0x2dbc08,_0x39360c,_0x2ad884){const _0x1b9726=_0x2a107e;this[_0x1b9726(0x1a1)]=_0x2ad884,this[_0x1b9726(0x189)]=_0x2dbc08,this[_0x1b9726(0x19f)]=_0x39360c,_0x2ad884<=0x0&&(_0x1b9726(0x22c)!=='ONJYQ'?(this[_0x1b9726(0x26b)]=_0x3ca5ec(_0x560560['$1'])*0.01,this[_0x1b9726(0x19f)]=this[_0x1b9726(0x26b)]):(this['_scaleBaseX']=this[_0x1b9726(0x189)],this[_0x1b9726(0x26b)]=this['_scaleBaseTargetY']));},Game_CharacterBase[_0x2a107e(0x1e8)]['startMapEventBreathingChange']=function(_0x460768,_0x1e8053,_0x405389,_0x30987b,_0x48c6a8){const _0x4ef7eb=_0x2a107e;this['_breathingChangeDuration']=_0x48c6a8,this[_0x4ef7eb(0x1ed)]=_0x460768,this[_0x4ef7eb(0x1cd)]=_0x1e8053,this['_breathingChangeSpeedX']=_0x405389,this[_0x4ef7eb(0x169)]=_0x30987b,_0x48c6a8<=0x0&&(_0x4ef7eb(0x151)!==_0x4ef7eb(0x1f6)?(this['_breathingRateX']=this[_0x4ef7eb(0x1ed)],this[_0x4ef7eb(0x183)]=this[_0x4ef7eb(0x1cd)],this['_breathingSpeedX']=this[_0x4ef7eb(0x1f4)],this[_0x4ef7eb(0x259)]=this['_breathingChangeSpeedY']):(this[_0x4ef7eb(0x279)]=_0x578412(_0xfe592e['$1'])*0.01,this[_0x4ef7eb(0x189)]=this[_0x4ef7eb(0x279)]));},Game_CharacterBase[_0x2a107e(0x1e8)]['updateScaleBaseChanges']=function(){const _0x349d43=_0x2a107e;if(!this[_0x349d43(0x1a1)])return;this['_scaleBaseTargetX']=this[_0x349d43(0x189)]??this['_scaleBaseX'],this[_0x349d43(0x19f)]=this[_0x349d43(0x19f)]??this[_0x349d43(0x26b)];const _0x1e2f4e=this[_0x349d43(0x1a1)];this[_0x349d43(0x279)]=(this[_0x349d43(0x279)]*(_0x1e2f4e-0x1)+this['_scaleBaseTargetX'])/_0x1e2f4e,this[_0x349d43(0x26b)]=(this[_0x349d43(0x26b)]*(_0x1e2f4e-0x1)+this[_0x349d43(0x19f)])/_0x1e2f4e,this[_0x349d43(0x1a1)]--;if(this[_0x349d43(0x1a1)]<=0x0){if(_0x349d43(0x1ba)===_0x349d43(0x1e7)){if(!_0x243966[_0x349d43(0x222)]())return;_0x19422b[_0x349d43(0x252)](_0x329ddc,_0x42e92c);const _0x4bb577=_0x23a71a[_0x349d43(0x17c)](),_0x58e06d=_0x30a1d4[_0x349d43(0x1bb)]||_0x4bb577[_0x349d43(0x1aa)](),_0x2b7a6a=_0x2bc73d[_0x349d43(0x188)](_0x58e06d);if(!_0x2b7a6a)return;const _0x297291=_0x1f0499[_0x349d43(0x220)](_0x15939c[_0x349d43(0x284)]||0x0,_0xe5be1b[_0x349d43(0x21c)]||0x0),_0x3d80f5=_0x16f366[_0x349d43(0x167)](_0xb9e4d2['FloatMin']||0x0,_0x1e5571[_0x349d43(0x21c)]||0x0),_0x57f5a9=_0x4fbb9a[_0x349d43(0x19e)]??(_0x2b7a6a[_0x349d43(0x223)]||0.01),_0x40f379=_0x29dd28[_0x349d43(0x1b3)]??0x0;_0x2b7a6a[_0x349d43(0x227)](_0x297291,_0x3d80f5,_0x57f5a9,_0x40f379);}else this[_0x349d43(0x279)]=this[_0x349d43(0x189)],this[_0x349d43(0x26b)]=this[_0x349d43(0x19f)];}},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x1c3)]=function(){const _0x1688b0=_0x2a107e;if(!this['_breathingChangeDuration'])return;this['_breathingChangeTargetX']=this['_breathingChangeTargetX']??this[_0x1688b0(0x23b)],this['_breathingChangeTargetY']=this[_0x1688b0(0x1cd)]??this[_0x1688b0(0x183)],this[_0x1688b0(0x1f4)]=this[_0x1688b0(0x1f4)]??this[_0x1688b0(0x152)],this[_0x1688b0(0x169)]=this[_0x1688b0(0x169)]??this['_breathingSpeedY'];const _0x106810=this[_0x1688b0(0x21f)];this[_0x1688b0(0x23b)]=(this[_0x1688b0(0x23b)]*(_0x106810-0x1)+this[_0x1688b0(0x1ed)])/_0x106810,this['_breathingRateY']=(this[_0x1688b0(0x183)]*(_0x106810-0x1)+this['_breathingChangeTargetY'])/_0x106810,this[_0x1688b0(0x152)]=(this[_0x1688b0(0x152)]*(_0x106810-0x1)+this[_0x1688b0(0x1f4)])/_0x106810,this['_breathingSpeedY']=(this['_breathingSpeedY']*(_0x106810-0x1)+this[_0x1688b0(0x169)])/_0x106810,this[_0x1688b0(0x21f)]--,this[_0x1688b0(0x1a1)]<=0x0&&(_0x1688b0(0x270)!=='bbqPD'?(this[_0x1688b0(0x23b)]=this['_breathingChangeTargetX'],this[_0x1688b0(0x183)]=this[_0x1688b0(0x1cd)],this[_0x1688b0(0x152)]=this[_0x1688b0(0x1f4)],this[_0x1688b0(0x259)]=this['_breathingChangeSpeedY']):(this[_0x1688b0(0x196)]=this[_0x1688b0(0x196)]||0x0,this['_hueUpdatePerFrame']=this[_0x1688b0(0x24a)]||0x0,this[_0x1688b0(0x24a)]!==0x0&&(this['_hue']+=this['_hueUpdatePerFrame'])));},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x1ec)]=function(){const _0x48a430=_0x2a107e;this[_0x48a430(0x1fb)]=this['_scaleBaseX'],this[_0x48a430(0x17e)]=this[_0x48a430(0x26b)];},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x275)]=function(){const _0x1ec791=_0x2a107e;this[_0x1ec791(0x1fb)]+=VisuMZ[_0x1ec791(0x197)][_0x1ec791(0x216)](this[_0x1ec791(0x23b)],this[_0x1ec791(0x152)],this[_0x1ec791(0x16b)]),this['_scaleY']+=VisuMZ[_0x1ec791(0x197)]['applyBreathingCalculations'](this[_0x1ec791(0x183)],this['_breathingSpeedY'],this['_breathingRngY']);},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x216)]=function(_0x3e9db9,_0x536425,_0x35d309){const _0x5cf028=_0x2a107e;if(_0x3e9db9===0x0)return 0x0;const _0x2fd5ab=Graphics[_0x5cf028(0x21b)]+_0x35d309;return Math[_0x5cf028(0x23a)](_0x2fd5ab*_0x536425)*_0x3e9db9;},Game_CharacterBase[_0x2a107e(0x1e8)]['startMapEventTintChange']=function(_0xa42480,_0x31f107){const _0x972050=_0x2a107e;this['_tintDuration']=_0x31f107,this[_0x972050(0x186)]=_0xa42480[_0x972050(0x15a)](0x0),_0x31f107<=0x0&&(this['_tintCurrent']=this['_tintTarget'][_0x972050(0x28a)]());},Game_CharacterBase['prototype']['updateMapEventTintChange']=function(){const _0x31abbe=_0x2a107e;if(!this[_0x31abbe(0x15f)])return;const _0xd0e8cd=this['_tintDuration'],_0x31a031=this[_0x31abbe(0x164)],_0x4da237=this[_0x31abbe(0x186)];for(let _0x3bf650=0x0;_0x3bf650<=0x3;_0x3bf650++){_0x31a031[_0x3bf650]=(_0x31a031[_0x3bf650]*(_0xd0e8cd-0x1)+_0x4da237[_0x3bf650])/_0xd0e8cd;}this['_tintDuration']--;if(this[_0x31abbe(0x15f)]<=0x0)for(let _0x4a7c4f=0x0;_0x4a7c4f<=0x3;_0x4a7c4f++){_0x31a031[_0x4a7c4f]=_0x4da237[_0x4a7c4f];}},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x1e0)]=function(_0x5d561f,_0x3ebb07,_0x200a69){const _0xb4437a=_0x2a107e;this[_0xb4437a(0x159)]=_0x200a69;if(_0x200a69===0x0)this[_0xb4437a(0x1a8)]=_0x3ebb07,this[_0xb4437a(0x282)]=_0x5d561f[_0xb4437a(0x15a)](0x0);else{if(_0xb4437a(0x1de)===_0xb4437a(0x163)){if(!this[_0xb4437a(0x298)])return;this[_0xb4437a(0x1e6)]=this['_floatHeightMin']||0x0,this[_0xb4437a(0x1b7)]=this[_0xb4437a(0x1b7)]||0x0,this['_floatSpeed']=this[_0xb4437a(0x223)]||_0x2fc2b6['MAP_EVENT_EFFECTS'][_0xb4437a(0x23c)][_0xb4437a(0x1c1)],this[_0xb4437a(0x1d2)]=this['_floatChangeMinTarget']||0x0,this[_0xb4437a(0x21a)]=this[_0xb4437a(0x21a)]||0x0,this['_floatChangeSpeedTarget']=this[_0xb4437a(0x1bc)]||0x0;const _0x15dde5=this['_floatChangeDuration'];this[_0xb4437a(0x1e6)]=(this['_floatHeightMin']*(_0x15dde5-0x1)+this['_floatChangeMinTarget'])/_0x15dde5,this[_0xb4437a(0x1b7)]=(this[_0xb4437a(0x1b7)]*(_0x15dde5-0x1)+this[_0xb4437a(0x21a)])/_0x15dde5,this[_0xb4437a(0x223)]=(this[_0xb4437a(0x223)]*(_0x15dde5-0x1)+this[_0xb4437a(0x1bc)])/_0x15dde5,this[_0xb4437a(0x298)]--,this[_0xb4437a(0x298)]<=0x0&&(this[_0xb4437a(0x1e6)]=this[_0xb4437a(0x1d2)],this[_0xb4437a(0x1b7)]=this[_0xb4437a(0x21a)],this['_floatSpeed']=this[_0xb4437a(0x1bc)]);}else this[_0xb4437a(0x157)]=_0x3ebb07,this[_0xb4437a(0x1b6)]=_0x5d561f[_0xb4437a(0x15a)](0x0);}},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x286)]=function(){const _0x3c2966=_0x2a107e;this[_0x3c2966(0x172)](),this['updateMapEventFlashChange']();},Game_CharacterBase['prototype'][_0x2a107e(0x172)]=function(){const _0x4b432c=_0x2a107e;if(!this[_0x4b432c(0x159)])return;this[_0x4b432c(0x159)]=this[_0x4b432c(0x159)]??Math[_0x4b432c(0x167)](Game_Event[_0x4b432c(0x15d)][_0x4b432c(0x23c)][_0x4b432c(0x176)],0x1);if(Graphics[_0x4b432c(0x21b)]%this[_0x4b432c(0x159)]!==0x0)return;this[_0x4b432c(0x282)]=this['_flashStart'][_0x4b432c(0x15a)](0x0),this['_flashDuration']=this[_0x4b432c(0x157)];},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x278)]=function(){const _0x17c79f=_0x2a107e;if(!this[_0x17c79f(0x1a8)])return;const _0xea1b8d=this[_0x17c79f(0x1a8)],_0x45a856=this['_flashCurrent'];_0x45a856[0x3]=(_0x45a856[0x3]*(_0xea1b8d-0x1)+0x0)/_0xea1b8d,this[_0x17c79f(0x1a8)]--;if(this[_0x17c79f(0x1a8)]<=0x0){if('KWAmG'!==_0x17c79f(0x1f7))this[_0x17c79f(0x282)]=[0x0,0x0,0x0,0x0];else{let _0x3a3b3a=_0x141ee7[_0x17c79f(0x197)][_0x17c79f(0x201)][_0x17c79f(0x16f)](this);return this['_floatHeight']&&(this[_0x17c79f(0x158)]>=_0x48b20d[_0x17c79f(0x15d)][_0x17c79f(0x1ee)]&&(_0x3a3b3a=_0xc5bc[_0x17c79f(0x167)](_0x3a3b3a,0x5))),_0x3a3b3a;}}},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x1ea)]=function(_0x39fe5a,_0x39f91b,_0x165d43,_0x1030c7){const _0x292ab1=_0x2a107e;this[_0x292ab1(0x238)]={'id':_0x39fe5a,'cycle':_0x39f91b??Game_Event[_0x292ab1(0x15d)][_0x292ab1(0x23c)]['repeatAniCycle'],'mirror':_0x165d43??Game_Event[_0x292ab1(0x15d)][_0x292ab1(0x23c)]['repeatAniMirror'],'mute':_0x1030c7??Game_Event['MAP_EVENT_EFFECTS']['default']['repeatAniMute']};},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x247)]=function(){const _0x42f9aa=_0x2a107e;if(!Imported[_0x42f9aa(0x15b)])return;if(!this[_0x42f9aa(0x238)])return;if(!this['_repeatAnimation']['id'])return;if(Graphics['frameCount']%this['_repeatAnimation'][_0x42f9aa(0x297)]!==0x0)return;this[_0x42f9aa(0x18f)]();},Game_CharacterBase[_0x2a107e(0x1e8)][_0x2a107e(0x18f)]=function(){const _0x1be05d=_0x2a107e,_0x5da559=this[_0x1be05d(0x238)];$gameTemp['requestFauxAnimation']([this],_0x5da559['id'],_0x5da559[_0x1be05d(0x20d)],_0x5da559['mute']);},Game_Event['MAP_EVENT_EFFECTS']={'default':{'floatSpeed':VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x214)][_0x2a107e(0x1c1)]??0.04,'sidestepSpeed':VisuMZ['MapEventEffects'][_0x2a107e(0x214)][_0x2a107e(0x1da)]??0.04,'breathingSpeedX':VisuMZ['MapEventEffects'][_0x2a107e(0x214)][_0x2a107e(0x231)]??0.08,'breathingSpeedY':VisuMZ['MapEventEffects']['Settings'][_0x2a107e(0x24d)]??0.08,'flashDuration':VisuMZ[_0x2a107e(0x197)]['Settings'][_0x2a107e(0x232)]??0x14,'flashCycle':VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x214)][_0x2a107e(0x176)]??0x3c,'repeatAniCycle':VisuMZ['MapEventEffects'][_0x2a107e(0x214)][_0x2a107e(0x1d5)]??0x3c,'repeatAniMirror':VisuMZ['MapEventEffects'][_0x2a107e(0x214)][_0x2a107e(0x1d9)]??![],'repeatAniMute':VisuMZ['MapEventEffects'][_0x2a107e(0x214)]['repeatAniMute']??!![]},'floatHeightChangeZ':VisuMZ[_0x2a107e(0x197)]['Settings'][_0x2a107e(0x1ee)]??0x2a},VisuMZ[_0x2a107e(0x197)]['Game_Event_clearPageSettings']=Game_Event[_0x2a107e(0x1e8)][_0x2a107e(0x20f)],Game_Event[_0x2a107e(0x1e8)][_0x2a107e(0x20f)]=function(){const _0x2273d8=_0x2a107e;VisuMZ[_0x2273d8(0x197)]['Game_Event_clearPageSettings'][_0x2273d8(0x16f)](this),this[_0x2273d8(0x266)]();},VisuMZ[_0x2a107e(0x197)]['Game_Event_setupPageSettings']=Game_Event[_0x2a107e(0x1e8)]['setupPageSettings'],Game_Event['prototype'][_0x2a107e(0x14a)]=function(){const _0x5bc42c=_0x2a107e;VisuMZ[_0x5bc42c(0x197)][_0x5bc42c(0x1dd)]['call'](this),this[_0x5bc42c(0x177)]();},Game_Event[_0x2a107e(0x1e8)][_0x2a107e(0x177)]=function(){const _0x3822b9=_0x2a107e;if(!this[_0x3822b9(0x188)]())return;this[_0x3822b9(0x266)](),this['setupMapEventEffectsNotetags'](),this['setupMapEventEffectsCommentTags']();},Game_Event[_0x2a107e(0x1e8)][_0x2a107e(0x239)]=function(){const _0x2c4e33=_0x2a107e,_0x7c3a78=this[_0x2c4e33(0x188)]()[_0x2c4e33(0x198)];if(_0x7c3a78==='')return;this[_0x2c4e33(0x288)](_0x7c3a78);},Game_Event['prototype']['setupMapEventEffectsCommentTags']=function(){const _0x161bb6=_0x2a107e;if(!this['page']())return;const _0x37c254=this[_0x161bb6(0x230)]();let _0x321edb='';for(const _0x34a9a6 of _0x37c254){if([0x6c,0x198][_0x161bb6(0x294)](_0x34a9a6[_0x161bb6(0x291)])){if(_0x161bb6(0x194)===_0x161bb6(0x1a9))this[_0x161bb6(0x1e6)]=this[_0x161bb6(0x1d2)],this[_0x161bb6(0x1b7)]=this[_0x161bb6(0x21a)],this[_0x161bb6(0x223)]=this[_0x161bb6(0x1bc)];else{if(_0x321edb!=='')_0x321edb+='\x0a';_0x321edb+=_0x34a9a6[_0x161bb6(0x193)][0x0];}}}this[_0x161bb6(0x288)](_0x321edb);},Game_Event[_0x2a107e(0x1e8)]['checkMapEventEffectsStringTags']=function(_0x1c2123){const _0x26574a=_0x2a107e,_0x1e8a1b=VisuMZ[_0x26574a(0x197)][_0x26574a(0x295)];if(_0x1c2123['match'](_0x1e8a1b['Float'])){if('iaoqb'!==_0x26574a(0x251))this['_floatHeight']=Number(RegExp['$1']),this['_floatHeightMin']=this[_0x26574a(0x158)],this['_floatHeightMax']=this[_0x26574a(0x158)],this['_floatChangeMinTarget']=this['_floatHeightMin'],this[_0x26574a(0x21a)]=this[_0x26574a(0x1b7)];else{if(!_0x47de6c[_0x26574a(0x222)]())return;_0x5ef12c[_0x26574a(0x252)](_0x2936f7,_0x4df7f5);const _0x279887=_0x4bf72c,_0x9af337=_0x698311[_0x26574a(0x1ad)]||0x0,_0x316c4b=_0x364758[_0x26574a(0x1d6)]||0x0,_0x4d7e66=_0x507e6b['Duration']??0x0;_0x279887['startMapEventScaleChange'](_0x9af337,_0x316c4b,_0x4d7e66);}}else{if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x289)])){const _0x1cc069=Number(RegExp['$1']),_0x2b2060=Number(RegExp['$2']);this[_0x26574a(0x158)]=Math['min'](_0x1cc069,_0x2b2060),this[_0x26574a(0x1e6)]=Math['min'](_0x1cc069,_0x2b2060),this[_0x26574a(0x1b7)]=Math[_0x26574a(0x167)](_0x1cc069,_0x2b2060),this[_0x26574a(0x1d2)]=this['_floatHeightMin'],this[_0x26574a(0x21a)]=this[_0x26574a(0x1b7)];}}_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x19e)])&&(this[_0x26574a(0x223)]=Number(RegExp['$1']),this[_0x26574a(0x1bc)]=this[_0x26574a(0x223)]);if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x160)]))this[_0x26574a(0x27e)]=Math[_0x26574a(0x23e)](0xf4240);else _0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x26d)])&&(this[_0x26574a(0x27e)]=Number(RegExp['$1']));if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x28e)]))this[_0x26574a(0x25d)]=Number(RegExp['$1']),this[_0x26574a(0x1fe)]=this[_0x26574a(0x25d)],this[_0x26574a(0x17b)]=this[_0x26574a(0x25d)],this[_0x26574a(0x21e)]=this[_0x26574a(0x1fe)],this[_0x26574a(0x25c)]=this[_0x26574a(0x17b)];else{if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x281)])){if(_0x26574a(0x1c7)===_0x26574a(0x1c7)){const _0x294c43=Number(RegExp['$1']),_0xa0c8b0=Number(RegExp['$2']);this[_0x26574a(0x25d)]=Math[_0x26574a(0x220)](_0x294c43,_0xa0c8b0),this[_0x26574a(0x1fe)]=Math[_0x26574a(0x220)](_0x294c43,_0xa0c8b0),this[_0x26574a(0x17b)]=Math['max'](_0x294c43,_0xa0c8b0),this[_0x26574a(0x21e)]=this['_sidestepMin'],this[_0x26574a(0x25c)]=this[_0x26574a(0x17b)];}else this[_0x26574a(0x23d)]=_0x20c95f(_0x29cda9['$1']);}}_0x1c2123['match'](_0x1e8a1b[_0x26574a(0x174)])&&(_0x26574a(0x26f)!==_0x26574a(0x287)?(this['_sidestepSpeed']=Number(RegExp['$1']),this['_sidestepChangeSpeedTarget']=this[_0x26574a(0x180)]):(this[_0x26574a(0x192)](),this[_0x26574a(0x1b9)]()));if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x185)]))this['_sidestepRng']=Math[_0x26574a(0x23e)](0xf4240);else{if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['SidestepStatic'])){if(_0x26574a(0x17f)!=='WMoNF'){if(!this[_0x26574a(0x1a1)])return;this[_0x26574a(0x189)]=this[_0x26574a(0x189)]??this['_scaleBaseX'],this[_0x26574a(0x19f)]=this['_scaleBaseTargetY']??this[_0x26574a(0x26b)];const _0x587f63=this[_0x26574a(0x1a1)];this[_0x26574a(0x279)]=(this[_0x26574a(0x279)]*(_0x587f63-0x1)+this[_0x26574a(0x189)])/_0x587f63,this[_0x26574a(0x26b)]=(this['_scaleBaseY']*(_0x587f63-0x1)+this[_0x26574a(0x19f)])/_0x587f63,this[_0x26574a(0x1a1)]--,this[_0x26574a(0x1a1)]<=0x0&&(this[_0x26574a(0x279)]=this[_0x26574a(0x189)],this[_0x26574a(0x26b)]=this[_0x26574a(0x19f)]);}else this['_sidestepRng']=Number(RegExp['$1']);}}if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['Hue']))this[_0x26574a(0x196)]=Number(RegExp['$1']);else{if(_0x1c2123['match'](_0x1e8a1b[_0x26574a(0x1bd)]))this[_0x26574a(0x196)]=Math['randomInt'](0x168);else{if(_0x1c2123['match'](_0x1e8a1b[_0x26574a(0x18c)])){const _0x260fd3=Number(RegExp['$1']),_0x59d19a=Number(RegExp['$2']),_0x1c4e96=Math['min'](_0x260fd3,_0x59d19a),_0x3f2d95=Math['max'](_0x260fd3,_0x59d19a),_0xaa1472=_0x3f2d95-_0x1c4e96;this['_hue']=_0x1c4e96+Math['randomInt'](_0xaa1472+0x1);}}}if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x1ae)])){if(_0x26574a(0x269)===_0x26574a(0x269))this['_hueUpdatePerFrame']=Number(RegExp['$1']);else{if(!_0x4fd65a[_0x26574a(0x222)]())return;_0x5dacb3[_0x26574a(0x252)](_0xccf95c,_0x2b17f8);const _0x39ef46=_0x3016a3,_0x495faf=_0x44ff76['min'](_0x22e853['SidestepMin']||0x0,_0x47c60d['SidestepMax']||0x0),_0x2e776d=_0x99f0f3[_0x26574a(0x167)](_0x54a7c3[_0x26574a(0x243)]||0x0,_0x24875b[_0x26574a(0x267)]||0x0),_0x3e949a=_0x7a1b1e['SidestepSpeed']??(_0x39ef46[_0x26574a(0x180)]||0.01),_0x4439fe=_0x40bf11['Duration']??0x0;_0x39ef46['startMapEventSidestepChange'](_0x495faf,_0x2e776d,_0x3e949a,_0x4439fe);}}if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x263)])){if(_0x26574a(0x22f)!==_0x26574a(0x22f)){if(!this['page']())return;const _0x11845c=this[_0x26574a(0x230)]();let _0x16c6cc='';for(const _0x44363b of _0x11845c){if([0x6c,0x198][_0x26574a(0x294)](_0x44363b['code'])){if(_0x16c6cc!=='')_0x16c6cc+='\x0a';_0x16c6cc+=_0x44363b[_0x26574a(0x193)][0x0];}}this['checkMapEventEffectsStringTags'](_0x16c6cc);}else this[_0x26574a(0x23d)]=Number(RegExp['$1']);}_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['ShakePowerY'])&&(this[_0x26574a(0x25f)]=Number(RegExp['$1']));_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x1ac)])&&(this[_0x26574a(0x23d)]=Number(RegExp['$1']),this[_0x26574a(0x25f)]=this['_shakePowerX']);_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x272)])&&(this[_0x26574a(0x279)]=Number(RegExp['$1'])*0.01,this[_0x26574a(0x189)]=this[_0x26574a(0x279)]);if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x27d)])){if(_0x26574a(0x1b2)===_0x26574a(0x1a4))return _0x2d4437['status']&&_0x64a120[_0x26574a(0x168)][_0x26574a(0x294)]('['+_0x20270c+']');else this[_0x26574a(0x26b)]=Number(RegExp['$1'])*0.01,this[_0x26574a(0x19f)]=this[_0x26574a(0x26b)];}if(_0x1c2123['match'](_0x1e8a1b['ScaleBaseBoth'])){const _0x3da1e2=Number(RegExp['$1'])*0.01;this[_0x26574a(0x279)]=_0x3da1e2,this[_0x26574a(0x26b)]=_0x3da1e2,this[_0x26574a(0x189)]=this['_scaleBaseX'],this[_0x26574a(0x19f)]=this[_0x26574a(0x26b)];}_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x205)])&&(_0x26574a(0x237)!==_0x26574a(0x215)?(this[_0x26574a(0x23b)]=Number(RegExp['$1'])*0.01,this['_breathingChangeTargetX']=this[_0x26574a(0x23b)]):(this['_floatHeightMin']=this['_floatChangeMinTarget'],this[_0x26574a(0x1b7)]=this[_0x26574a(0x21a)],this[_0x26574a(0x223)]=this[_0x26574a(0x1bc)]));_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x22d)])&&(_0x26574a(0x1be)!=='otxMm'?(this[_0x26574a(0x183)]=Number(RegExp['$1'])*0.01,this[_0x26574a(0x1cd)]=this[_0x26574a(0x183)]):(this[_0x26574a(0x259)]=_0x232f1e(_0x10f86d['$1']),this[_0x26574a(0x169)]=this['_breathingSpeedY']));if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x1f5)])){const _0x194a95=Number(RegExp['$1'])*0.01;this[_0x26574a(0x23b)]=_0x194a95,this[_0x26574a(0x183)]=_0x194a95,this[_0x26574a(0x1ed)]=this['_breathingRateX'],this[_0x26574a(0x1cd)]=this[_0x26574a(0x183)];}if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x273)])){if('VdiZl'===_0x26574a(0x170))this[_0x26574a(0x152)]=Number(RegExp['$1']),this[_0x26574a(0x1f4)]=this[_0x26574a(0x152)];else{if(!_0x5b4dff[_0x26574a(0x222)]())return;_0x2b86e0[_0x26574a(0x252)](_0x1c7eb,_0x3f66c7);const _0x5db828=_0x5b9cfd[_0x26574a(0x17c)](),_0x533330=_0x3adc7b[_0x26574a(0x1bb)]||_0x5db828[_0x26574a(0x1aa)](),_0x22814e=_0x1eb9e5['event'](_0x533330);if(!_0x22814e)return;_0x22814e['_hue']=_0xf6a8a1[_0x26574a(0x195)]||0x0;}}_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['BreathSpeedY'])&&('FQfHN'===_0x26574a(0x1eb)?(this[_0x26574a(0x259)]=Number(RegExp['$1']),this[_0x26574a(0x169)]=this[_0x26574a(0x259)]):_0x37a9d7[_0x17706a]=(_0xbe2ba9[_0x4043f1]*(_0x3363a6-0x1)+_0xfdf70b[_0x5f4282])/_0x181597);if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x280)])){const _0x3bbdc1=Number(RegExp['$1']);this[_0x26574a(0x152)]=_0x3bbdc1,this[_0x26574a(0x259)]=_0x3bbdc1,this['_breathingChangeSpeedX']=this[_0x26574a(0x152)],this[_0x26574a(0x169)]=this[_0x26574a(0x259)];}if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x14c)]))_0x26574a(0x16c)===_0x26574a(0x1c2)?(this[_0x26574a(0x16b)]=_0x469679[_0x26574a(0x23e)](0xf4240),this['_breathingRngY']=_0x3b25ef['randomInt'](0xf4240)):this['_breathingRngX']=Math[_0x26574a(0x23e)](0xf4240);else _0x1c2123['match'](_0x1e8a1b['BreathStaticX'])&&(_0x26574a(0x213)===_0x26574a(0x213)?this[_0x26574a(0x16b)]=Number(RegExp['$1']):this[_0x26574a(0x16b)]=_0x1eb2c4(_0x149fe0['$1']));if(_0x1c2123['match'](_0x1e8a1b[_0x26574a(0x293)]))this['_breathingRngY']=Math[_0x26574a(0x23e)](0xf4240);else _0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x1ff)])&&(_0x26574a(0x221)!=='CucWy'?(this[_0x26574a(0x219)]['x']=this[_0x26574a(0x27a)][_0x26574a(0x1fb)],this[_0x26574a(0x219)]['y']=this[_0x26574a(0x27a)][_0x26574a(0x17e)]):this[_0x26574a(0x1c4)]=Number(RegExp['$1']));if(_0x1c2123['match'](_0x1e8a1b[_0x26574a(0x154)]))this[_0x26574a(0x16b)]=Math[_0x26574a(0x23e)](0xf4240),this[_0x26574a(0x1c4)]=Math[_0x26574a(0x23e)](0xf4240);else{if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x1df)])){if(_0x26574a(0x15e)===_0x26574a(0x15e)){const _0x6b6e6e=Number(RegExp['$1']);this[_0x26574a(0x16b)]=_0x6b6e6e,this[_0x26574a(0x1c4)]=_0x6b6e6e;}else{if(!_0x4e7642['isInstanceOfSceneMap']())return;_0x3d6736[_0x26574a(0x252)](_0xbaff1e,_0x487e19);const _0x58cd6c=_0xa6be1e[_0x26574a(0x17c)](),_0x10e83b=_0x133986[_0x26574a(0x1bb)]||_0x58cd6c[_0x26574a(0x1aa)](),_0x67eb7c=_0x50c66e['event'](_0x10e83b);if(!_0x67eb7c)return;_0x67eb7c[_0x26574a(0x23d)]=_0xd1d0a5[_0x26574a(0x260)](_0x22f23c['ShakeX']||0x0),_0x67eb7c['_shakePowerY']=_0x3a9ac2[_0x26574a(0x260)](_0x27aa74['ShakeX']||0x0);}}}if(_0x1c2123['match'](_0x1e8a1b[_0x26574a(0x20b)])){const _0x4c1b1a=RegExp['$1'][_0x26574a(0x225)](',')['map'](_0x3df967=>Number(_0x3df967));_0x4c1b1a[0x0]=(_0x4c1b1a[0x0]||0x0)[_0x26574a(0x27f)](-0xff,0xff),_0x4c1b1a[0x1]=(_0x4c1b1a[0x1]||0x0)['clamp'](-0xff,0xff),_0x4c1b1a[0x2]=(_0x4c1b1a[0x2]||0x0)[_0x26574a(0x27f)](-0xff,0xff),_0x4c1b1a[0x3]=(_0x4c1b1a[0x3]||0x0)[_0x26574a(0x27f)](0x0,0xff),this[_0x26574a(0x164)]=_0x4c1b1a[_0x26574a(0x15a)](0x0),this[_0x26574a(0x186)]=_0x4c1b1a['slice'](0x0);}if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x200)])){if(_0x26574a(0x22a)!==_0x26574a(0x1e3)){const _0x278251=RegExp['$1'][_0x26574a(0x225)](',')[_0x26574a(0x276)](_0x3187ac=>Number(_0x3187ac));_0x278251[0x0]=(_0x278251[0x0]||0x0)[_0x26574a(0x27f)](0x0,0xff),_0x278251[0x1]=(_0x278251[0x1]||0x0)[_0x26574a(0x27f)](0x0,0xff),_0x278251[0x2]=(_0x278251[0x2]||0x0)[_0x26574a(0x27f)](0x0,0xff),_0x278251[0x3]=(_0x278251[0x3]||0x0)[_0x26574a(0x27f)](0x0,0xff),this['_flashCurrent']=_0x278251['slice'](0x0),this[_0x26574a(0x1b6)]=_0x278251[_0x26574a(0x15a)](0x0),this['_flashCycle']=Math['max'](Game_Event[_0x26574a(0x15d)][_0x26574a(0x23c)]['flashCycle'],0x1);}else{if(!this[_0x26574a(0x25f)])return 0x0;return _0x44207e[_0x26574a(0x23e)](this['_shakePowerY']);}}_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['FlashDuration'])&&(this['_flashWholeDuration']=Math[_0x26574a(0x167)](Number(RegExp['$1']),0x1),this[_0x26574a(0x159)]=Math[_0x26574a(0x167)](Game_Event[_0x26574a(0x15d)]['default'][_0x26574a(0x176)],0x1));_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['FlashCycle'])&&(this[_0x26574a(0x159)]=Math[_0x26574a(0x167)](Number(RegExp['$1']),0x1));if(Imported[_0x26574a(0x15b)]){_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x204)])&&(this[_0x26574a(0x238)]['id']=Number(RegExp['$1'])||0x0);if(_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['RepeatAniCycle'])){if(_0x26574a(0x25b)===_0x26574a(0x25b))this['_repeatAnimation']['cycle']=Number(RegExp['$1'])||0x1;else{if(!_0x55ade4[_0x26574a(0x222)]())return;_0x35f282[_0x26574a(0x252)](_0x529e1d,_0x5dfd70);const _0x5e961d=(_0x47a852[_0x26574a(0x1ca)]||0x0)-0x1,_0x273466=_0x2dc5f3[_0x26574a(0x20a)]()[_0x26574a(0x246)](_0x5e961d);if(!_0x273466)return;_0x273466[_0x26574a(0x23d)]=_0x565727[_0x26574a(0x260)](_0x91bf97[_0x26574a(0x1c5)]||0x0),_0x273466['_shakePowerY']=_0x53581c[_0x26574a(0x260)](_0x55e721[_0x26574a(0x1c5)]||0x0);}}_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b['RepeatAniMirrorOn'])&&(this['_repeatAnimation']['mirror']=!![]),_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x16d)])&&(_0x26574a(0x217)===_0x26574a(0x217)?this[_0x26574a(0x238)][_0x26574a(0x20d)]=![]:(_0x184c6c[_0x26574a(0x197)][_0x26574a(0x268)][_0x26574a(0x16f)](this),this[_0x26574a(0x266)]())),_0x1c2123[_0x26574a(0x1cc)](_0x1e8a1b[_0x26574a(0x296)])&&(this[_0x26574a(0x238)]['mute']=!![]),_0x1c2123['match'](_0x1e8a1b['RepeatAniMuteOff'])&&(this[_0x26574a(0x238)][_0x26574a(0x256)]=![]);}},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x233)]=Sprite_Character[_0x2a107e(0x1e8)][_0x2a107e(0x1b8)],Sprite_Character['prototype']['update']=function(){const _0x1aa569=_0x2a107e;!Imported[_0x1aa569(0x26a)]&&this[_0x1aa569(0x1e1)](),VisuMZ[_0x1aa569(0x197)][_0x1aa569(0x233)][_0x1aa569(0x16f)](this);},Sprite_Character[_0x2a107e(0x1e8)][_0x2a107e(0x1e1)]=function(){const _0x11daec=_0x2a107e;this['scale']['x']=this[_0x11daec(0x27a)]['_scaleX'],this[_0x11daec(0x219)]['y']=this[_0x11daec(0x27a)][_0x11daec(0x17e)];},VisuMZ[_0x2a107e(0x197)][_0x2a107e(0x173)]=Sprite_Character['prototype'][_0x2a107e(0x212)],Sprite_Character[_0x2a107e(0x1e8)][_0x2a107e(0x212)]=function(){const _0x418521=_0x2a107e;VisuMZ[_0x418521(0x197)][_0x418521(0x173)][_0x418521(0x16f)](this),this[_0x418521(0x27a)]&&!this['_character'][_0x418521(0x161)]&&(_0x418521(0x285)!=='YTxQl'?(_0x324d6b['MapEventEffects'][_0x418521(0x173)][_0x418521(0x16f)](this),this[_0x418521(0x27a)]&&!this[_0x418521(0x27a)]['_erased']&&this[_0x418521(0x208)]()):this[_0x418521(0x208)]());},Sprite_Character[_0x2a107e(0x1e8)][_0x2a107e(0x208)]=function(){const _0x271d83=_0x2a107e;this[_0x271d83(0x18e)](),this[_0x271d83(0x1e5)](),this[_0x271d83(0x245)]();},Sprite_Character[_0x2a107e(0x1e8)][_0x2a107e(0x18e)]=function(){const _0x23242b=_0x2a107e;if(this[_0x23242b(0x228)]===this[_0x23242b(0x27a)]['_hue'])return;this['_lastHue']=this[_0x23242b(0x27a)][_0x23242b(0x196)],this[_0x23242b(0x21d)](this[_0x23242b(0x228)]);},Sprite_Character['prototype']['updateMapEventTint']=function(){const _0x435b1c=_0x2a107e;if(!this[_0x435b1c(0x27a)]['_tintCurrent'])return;this[_0x435b1c(0x244)](this[_0x435b1c(0x27a)]['_tintCurrent']);},Sprite_Character['prototype'][_0x2a107e(0x245)]=function(){const _0x51d41b=_0x2a107e;if(!this[_0x51d41b(0x27a)][_0x51d41b(0x282)])return;this['setBlendColor'](this[_0x51d41b(0x27a)][_0x51d41b(0x282)]);};